/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.core.util.xml.marshalling.xstream;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.io.IOException;
import java.io.Writer;
import org.apache.commons.lang.ArrayUtils;
import org.craftercms.core.service.Item;
import org.craftercms.core.service.Tree;
import org.craftercms.core.util.xml.marshalling.xstream.Dom4jDocumentConverter;
import org.craftercms.core.util.xml.marshalling.xstream.EscapingCompactWriter;
import org.dom4j.Document;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import org.springframework.oxm.XmlMappingException;
import org.springframework.oxm.xstream.XStreamMarshaller;

public class CrafterXStreamMarshaller
extends XStreamMarshaller {
    public static final String XML_DECLARATION = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
    public static final String ITEM_CLASS_ALIAS = "item";
    public static final String TREE_CLASS_ALIAS = "tree";
    public static final String DOCUMENT_CLASS_ALIAS = "document";
    protected Class[] unsupportedClasses;
    protected boolean suppressXmlDeclaration = false;

    public void setUnsupportedClasses(Class[] unsupportedClasses) {
        this.unsupportedClasses = unsupportedClasses;
    }

    public void setSuppressXmlDeclaration(boolean suppressXmlDeclaration) {
        this.suppressXmlDeclaration = suppressXmlDeclaration;
    }

    protected void customizeXStream(XStream xstream) {
        this.getXStream().alias(ITEM_CLASS_ALIAS, Item.class);
        this.getXStream().alias(TREE_CLASS_ALIAS, Tree.class);
        this.getXStream().aliasType(DOCUMENT_CLASS_ALIAS, Document.class);
        this.getXStream().registerConverter((Converter)Dom4jDocumentConverter.INSTANCE);
    }

    public boolean supports(Class clazz) {
        if (ArrayUtils.isNotEmpty((Object[])this.unsupportedClasses)) {
            for (Class unsupportedClass : this.unsupportedClasses) {
                if (!unsupportedClass.isAssignableFrom(clazz)) continue;
                return false;
            }
        }
        return super.supports(clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void marshalWriter(Object graph, Writer writer) throws XmlMappingException, IOException {
        if (graph instanceof Document) {
            OutputFormat outputFormat = OutputFormat.createCompactFormat();
            outputFormat.setSuppressDeclaration(this.suppressXmlDeclaration);
            XMLWriter xmlWriter = new XMLWriter(writer, outputFormat);
            try {
                xmlWriter.write((Document)graph);
            }
            finally {
                try {
                    xmlWriter.flush();
                }
                catch (Exception ex) {
                    this.logger.debug((Object)"Could not flush XMLWriter", (Throwable)ex);
                }
            }
        }
        if (!this.suppressXmlDeclaration) {
            writer.write(XML_DECLARATION);
        }
        EscapingCompactWriter streamWriter = new EscapingCompactWriter(writer);
        try {
            this.getXStream().marshal(graph, (HierarchicalStreamWriter)streamWriter);
        }
        catch (Exception ex) {
            throw this.convertXStreamException(ex, true);
        }
        finally {
            try {
                streamWriter.flush();
            }
            catch (Exception ex) {
                this.logger.debug((Object)"Could not flush HierarchicalStreamWriter", (Throwable)ex);
            }
        }
    }
}

