/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.core.util.xml.marshalling.xstream;

import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import org.craftercms.core.util.xml.marshalling.xstream.EscapingCompactWriter;
import org.dom4j.Document;

public class Dom4jDocumentConverter
implements Converter {
    public static final Dom4jDocumentConverter INSTANCE = new Dom4jDocumentConverter();

    private Dom4jDocumentConverter() {
    }

    public boolean canConvert(Class type) {
        return Document.class.isAssignableFrom(type);
    }

    public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
        Document document = (Document)source;
        EscapingCompactWriter escapingCompactWriter = (EscapingCompactWriter)writer.underlyingWriter();
        escapingCompactWriter.setEscapeXml(false);
        escapingCompactWriter.setValue(document.getRootElement().asXML());
        escapingCompactWriter.setEscapeXml(true);
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        throw new UnsupportedOperationException();
    }
}

