/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.core.xml.mergers.impl;

import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.craftercms.core.exception.XmlMergeException;
import org.craftercms.core.xml.mergers.DescriptorMerger;
import org.craftercms.core.xml.mergers.impl.cues.MergeCue;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.springframework.beans.factory.annotation.Required;

public class DescriptorMergerImpl
implements DescriptorMerger {
    private MergeCue initialMergeCue;
    private Map<String, String> initialMergeCueParams = Collections.emptyMap();

    @Required
    public void setInitialMergeCue(MergeCue initialMergeCue) {
        this.initialMergeCue = initialMergeCue;
    }

    public void setInitialMergeCueParams(Map<String, String> initialMergeCueParams) {
        this.initialMergeCueParams = initialMergeCueParams;
    }

    @Override
    public Document merge(List<Document> descriptorsToMerge) throws XmlMergeException {
        Document merged = DocumentHelper.createDocument();
        if (CollectionUtils.isNotEmpty(descriptorsToMerge)) {
            Element mergedRoot = descriptorsToMerge.get(0).getRootElement().createCopy();
            ListIterator<Document> i = descriptorsToMerge.listIterator(1);
            while (i.hasNext()) {
                Element descriptorRoot = ((Document)i.next()).getRootElement().createCopy();
                mergedRoot = this.initialMergeCue.merge(mergedRoot, descriptorRoot, this.initialMergeCueParams);
            }
            merged.add(mergedRoot);
        }
        return merged;
    }
}

