/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.core.xml.mergers.impl.cues.impl;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.craftercms.core.exception.XmlMergeException;
import org.craftercms.core.util.CollectionUtils;
import org.craftercms.core.xml.mergers.impl.cues.ElementMergeMatcher;
import org.craftercms.core.xml.mergers.impl.cues.MergeCueContext;
import org.craftercms.core.xml.mergers.impl.cues.MergeCueResolver;
import org.craftercms.core.xml.mergers.impl.cues.impl.AbstractMergeCue;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.QName;
import org.springframework.beans.factory.annotation.Required;

public class MergeParentAndChildMergeCue
extends AbstractMergeCue {
    protected ElementMergeMatcher elementMergeMatcher;
    protected MergeCueResolver mergeCueResolver;
    protected String mergeOrderParamName;
    protected String defaultMergeOrder;

    @Required
    public void setElementMergeMatcher(ElementMergeMatcher elementMergeMatcher) {
        this.elementMergeMatcher = elementMergeMatcher;
    }

    @Required
    public void setMergeCueResolver(MergeCueResolver mergeCueResolver) {
        this.mergeCueResolver = mergeCueResolver;
    }

    @Required
    public void setMergeOrderParamName(String mergeOrderParamName) {
        this.mergeOrderParamName = mergeOrderParamName;
    }

    @Required
    public void setDefaultMergeOrder(String defaultMergeOrder) {
        this.defaultMergeOrder = defaultMergeOrder;
    }

    @Override
    public Element merge(Element parent, Element child, Map<String, String> params) throws XmlMergeException {
        Element merged = DocumentHelper.createElement((QName)child.getQName());
        CollectionUtils.move(child.attributes(), merged.attributes());
        if (parent.isTextOnly() && child.isTextOnly()) {
            String parentText = parent.getText();
            String childText = child.getText();
            if (this.getMergeOrder(params).equalsIgnoreCase("after")) {
                merged.setText(parentText + childText);
            } else {
                merged.setText(childText + parentText);
            }
        } else {
            List parentElements = parent.elements();
            List childElements = child.elements();
            List mergedElements = merged.elements();
            if (CollectionUtils.isNotEmpty((Collection)parentElements) && CollectionUtils.isNotEmpty((Collection)childElements)) {
                Iterator i = parentElements.iterator();
                while (i.hasNext()) {
                    Element parentElement = (Element)i.next();
                    boolean elementsMerged = false;
                    Iterator j = childElements.iterator();
                    while (!elementsMerged && j.hasNext()) {
                        Element childElement = (Element)j.next();
                        if (!this.elementMergeMatcher.matchForMerge(parentElement, childElement)) continue;
                        MergeCueContext context = this.mergeCueResolver.getMergeCue(parentElement, childElement);
                        if (context != null) {
                            i.remove();
                            j.remove();
                            Element mergedElement = context.doMerge();
                            mergedElements.add(mergedElement);
                            elementsMerged = true;
                            continue;
                        }
                        throw new XmlMergeException("No merge cue was resolved for matching elements " + parentElement + " (parent) and " + childElement + " (child)");
                    }
                }
            }
            if (this.getMergeOrder(params).equalsIgnoreCase("after")) {
                CollectionUtils.move(parentElements, mergedElements);
                CollectionUtils.move(childElements, mergedElements);
            } else {
                CollectionUtils.move(childElements, mergedElements);
                CollectionUtils.move(parentElements, mergedElements);
            }
        }
        return merged;
    }

    protected String getMergeOrder(Map<String, String> mergeParams) throws XmlMergeException {
        String mergeOrder = mergeParams.get(this.mergeOrderParamName);
        if (mergeOrder != null) {
            return mergeOrder;
        }
        return this.defaultMergeOrder;
    }
}

