/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.core.cache.impl.store;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.PreDestroy;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import net.sf.ehcache.config.CacheConfiguration;
import net.sf.ehcache.config.Configuration;
import net.sf.ehcache.config.ConfigurationFactory;
import org.craftercms.core.cache.CacheItem;
import org.craftercms.core.cache.impl.CacheStoreAdapter;
import org.craftercms.core.exception.InvalidScopeException;

public class EhCacheStoreAdapter
implements CacheStoreAdapter {
    public static final String SCOPE_MANAGER_NAME = "crafter.scopeManager";
    private CacheManager scopeManager;

    public EhCacheStoreAdapter() {
        Configuration scopeManagerConfig = ConfigurationFactory.parseConfiguration();
        scopeManagerConfig.setName(SCOPE_MANAGER_NAME);
        this.scopeManager = CacheManager.newInstance((Configuration)scopeManagerConfig);
    }

    public EhCacheStoreAdapter(List<CacheConfiguration> scopeConfigs) {
        this();
        for (CacheConfiguration scopeConfig : scopeConfigs) {
            this.scopeManager.addCache(new Cache(scopeConfig));
        }
    }

    @PreDestroy
    public void destroy() {
        this.scopeManager.shutdown();
    }

    @Override
    public boolean hasScope(String scope) throws Exception {
        return this.scopeManager.cacheExists(scope);
    }

    @Override
    public Collection<String> getScopes() throws Exception {
        return Arrays.asList(this.scopeManager.getCacheNames());
    }

    @Override
    public void addScope(String scope, int maxItemsInMemory) throws Exception {
        CacheConfiguration scopeConfig = new CacheConfiguration(scope, maxItemsInMemory);
        this.scopeManager.addCache(new Cache(scopeConfig));
    }

    @Override
    public void removeScope(String scope) throws Exception {
        this.scopeManager.removeCache(scope);
    }

    @Override
    public int getSize(String scope) throws Exception {
        return this.getScopeCache(scope).getSize();
    }

    @Override
    public Collection<Object> getKeys(String scope) throws Exception {
        return this.getScopeCache(scope).getKeys();
    }

    @Override
    public boolean hasKey(String scope, Object key) throws Exception {
        return this.getScopeCache(scope).isKeyInCache(key);
    }

    @Override
    public CacheItem get(String scope, Object key) throws Exception {
        Element element = this.getScopeCache(scope).get(key);
        if (element != null) {
            return (CacheItem)element.getObjectValue();
        }
        return null;
    }

    @Override
    public void put(CacheItem item) throws Exception {
        this.getScopeCache(item.getScope()).put(new Element(item.getKey(), (Object)item));
    }

    @Override
    public boolean remove(String scope, Object key) throws Exception {
        return this.getScopeCache(scope).remove(key);
    }

    @Override
    public void clearAll() throws Exception {
        this.scopeManager.clearAll();
    }

    @Override
    public void clearScope(String scope) throws Exception {
        this.getScopeCache(scope).removeAll();
    }

    private Cache getScopeCache(String scope) throws InvalidScopeException {
        Cache scopeCache = this.scopeManager.getCache(scope);
        if (scopeCache == null) {
            throw new InvalidScopeException("The scope " + scope + " doesn't exist");
        }
        return scopeCache;
    }
}

