/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.core.controller.rest;

import java.util.ArrayList;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections4.MapUtils;
import org.craftercms.core.controller.rest.RestControllerBase;
import org.craftercms.core.exception.InvalidContextException;
import org.craftercms.core.exception.ItemProcessingException;
import org.craftercms.core.exception.PathNotFoundException;
import org.craftercms.core.exception.StoreException;
import org.craftercms.core.exception.XmlFileParseException;
import org.craftercms.core.exception.XmlMergeException;
import org.craftercms.core.service.ContentStoreService;
import org.craftercms.core.service.Context;
import org.craftercms.core.service.Item;
import org.craftercms.core.service.Tree;
import org.craftercms.core.util.cache.impl.CachingAwareList;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.context.request.WebRequest;

@Controller
@RequestMapping(value={"/api/1/content_store"})
public class ContentStoreRestController
extends RestControllerBase {
    public static final String URL_ROOT = "/content_store";
    public static final String CACHE_CONTROL_HEADER_NAME = "Cache-Control";
    public static final String MUST_REVALIDATE_HEADER_VALUE = "must-revalidate";
    public static final String REQUEST_PARAM_CONTEXT_ID = "contextId";
    public static final String REQUEST_PARAM_URL = "url";
    public static final String REQUEST_PARAM_TREE_DEPTH = "depth";
    public static final String URL_DESCRIPTOR = "/descriptor";
    public static final String URL_ITEM = "/item";
    public static final String URL_CHILDREN = "/children";
    public static final String URL_TREE = "/tree";
    public static final String MODEL_ATTR_DESCRIPTOR = "descriptor";
    public static final String MODEL_ATTR_ITEM = "item";
    public static final String MODEL_ATTR_CHILDREN = "children";
    public static final String MODEL_ATTR_TREE = "tree";
    private ContentStoreService storeService;

    @Required
    public void setStoreService(ContentStoreService storeService) {
        this.storeService = storeService;
    }

    @RequestMapping(value={"/descriptor"}, method={RequestMethod.GET})
    public Map<String, Object> getDescriptor(WebRequest request, HttpServletResponse response, @RequestParam(value="contextId") String contextId, @RequestParam(value="url") String url) throws InvalidContextException, StoreException, PathNotFoundException, ItemProcessingException, XmlMergeException, XmlFileParseException {
        Map<String, Object> model = this.getItem(request, response, contextId, url);
        if (MapUtils.isNotEmpty(model)) {
            Item item = (Item)model.remove(MODEL_ATTR_ITEM);
            model.put(MODEL_ATTR_DESCRIPTOR, item.getDescriptorDom());
        }
        return model;
    }

    @RequestMapping(value={"/item"}, method={RequestMethod.GET})
    public Map<String, Object> getItem(WebRequest request, HttpServletResponse response, @RequestParam(value="contextId") String contextId, @RequestParam(value="url") String url) throws InvalidContextException, StoreException, PathNotFoundException, ItemProcessingException, XmlMergeException, XmlFileParseException {
        Context context = this.storeService.getContext(contextId);
        if (context == null) {
            throw new InvalidContextException("No context found for ID " + contextId);
        }
        Item item = this.storeService.getItem(context, url);
        if (item.getCachingTime() != null && this.checkNotModified(item.getCachingTime(), request, response)) {
            return null;
        }
        return this.createMessageModel(MODEL_ATTR_ITEM, item);
    }

    @RequestMapping(value={"/children"}, method={RequestMethod.GET})
    public Map<String, Object> getChildren(WebRequest request, HttpServletResponse response, @RequestParam(value="contextId") String contextId, @RequestParam(value="url") String url) throws InvalidContextException, StoreException, PathNotFoundException, ItemProcessingException, XmlMergeException, XmlFileParseException {
        Context context = this.storeService.getContext(contextId);
        if (context == null) {
            throw new InvalidContextException("No context found for ID " + contextId);
        }
        CachingAwareList children = (CachingAwareList)this.storeService.getChildren(context, url);
        if (children.getCachingTime() != null && this.checkNotModified(children.getCachingTime(), request, response)) {
            return null;
        }
        return this.createMessageModel(MODEL_ATTR_CHILDREN, new ArrayList(children));
    }

    @RequestMapping(value={"/tree"}, method={RequestMethod.GET})
    public Map<String, Object> getTree(WebRequest request, HttpServletResponse response, @RequestParam(value="contextId") String contextId, @RequestParam(value="url") String url, @RequestParam(value="depth", required=false) Integer depth) throws InvalidContextException, StoreException, PathNotFoundException, ItemProcessingException, XmlMergeException, XmlFileParseException {
        Tree tree;
        Context context = this.storeService.getContext(contextId);
        if (context == null) {
            throw new IllegalArgumentException("No context found for ID " + contextId);
        }
        if (depth == null) {
            depth = -1;
        }
        if ((tree = this.storeService.getTree(context, url, depth)).getCachingTime() != null && this.checkNotModified(tree.getCachingTime(), request, response)) {
            return null;
        }
        return this.createMessageModel(MODEL_ATTR_TREE, tree);
    }

    private boolean checkNotModified(long lastModifiedTimestamp, WebRequest request, HttpServletResponse response) {
        response.setHeader(CACHE_CONTROL_HEADER_NAME, MUST_REVALIDATE_HEADER_VALUE);
        return request.checkNotModified(lastModifiedTimestamp);
    }
}

