/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.core.service;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.craftercms.core.service.Item;

public class Tree
extends Item {
    protected List<Item> children;

    public Tree() {
        this.isFolder = true;
    }

    public Tree(Item item) {
        super(item);
        this.isFolder = true;
    }

    public Tree(Item item, boolean deepCopy) {
        super(item, deepCopy);
        this.isFolder = true;
    }

    public Tree(Tree tree) {
        this(tree, true);
    }

    public Tree(Tree tree, boolean deepCopy) {
        super(tree, deepCopy);
        if (deepCopy) {
            if (CollectionUtils.isNotEmpty(tree.children)) {
                this.children = new ArrayList<Item>(tree.children.size());
                for (Item child : tree.children) {
                    if (child instanceof Tree) {
                        this.children.add(new Tree((Tree)child, deepCopy));
                        continue;
                    }
                    this.children.add(new Item(child, deepCopy));
                }
            } else {
                this.children = new ArrayList<Item>();
            }
        } else {
            this.children = tree.children;
        }
    }

    @Override
    public void setFolder(boolean folder) {
        if (!folder) {
            throw new IllegalArgumentException("A tree must always be a folder");
        }
        super.setFolder(folder);
    }

    public List<Item> getChildren() {
        return this.children;
    }

    public void setChildren(List<Item> children) {
        this.children = children;
    }

    public void addChild(Item child) {
        if (this.children == null) {
            this.children = new ArrayList<Item>();
        }
        this.children.add(child);
    }

    public boolean removeChild(Item child) {
        if (this.children != null) {
            return this.children.remove(child);
        }
        return false;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Tree tree = (Tree)o;
        return !(this.children != null ? !this.children.equals(tree.children) : tree.children != null);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.children != null ? this.children.hashCode() : 0);
        return result;
    }

    @Override
    public String toString() {
        return "Tree[name='" + this.name + '\'' + ", url='" + this.url + '\'' + ", descriptorUrl='" + this.descriptorUrl + '\'' + ", properties=" + this.properties + ", children=" + this.children + ']';
    }
}

