/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.core.service.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.craftercms.core.cache.Cache;
import org.craftercms.core.cache.CacheItem;
import org.craftercms.core.cache.CacheLoader;
import org.craftercms.core.exception.InternalCacheEngineException;
import org.craftercms.core.exception.InvalidContextException;
import org.craftercms.core.exception.InvalidScopeException;
import org.craftercms.core.service.CacheService;
import org.craftercms.core.service.CachingOptions;
import org.craftercms.core.service.Context;
import org.springframework.beans.factory.annotation.Required;

public class CacheServiceImpl
implements CacheService {
    protected Cache cache;

    @Required
    public void setCache(Cache cache) {
        this.cache = cache;
    }

    @Override
    public Collection<String> getScopes() throws InternalCacheEngineException {
        return this.cache.getScopes();
    }

    @Override
    public void clearAll() throws InternalCacheEngineException {
        this.cache.clearAll();
    }

    @Override
    public void addScope(Context context) throws InternalCacheEngineException {
        if (context.isCacheOn()) {
            this.cache.addScope(context.getId(), context.getMaxAllowedItemsInCache());
        }
    }

    @Override
    public void removeScope(Context context) throws InvalidContextException, InternalCacheEngineException {
        if (context.isCacheOn()) {
            try {
                this.cache.removeScope(context.getId());
            }
            catch (InvalidScopeException e) {
                throw new InvalidContextException("No scope associated to context " + context);
            }
        }
    }

    @Override
    public boolean hasScope(Context context) throws InvalidContextException, InternalCacheEngineException {
        if (context.isCacheOn()) {
            try {
                return this.cache.hasScope(context.getId());
            }
            catch (InvalidScopeException e) {
                throw new InvalidContextException("No scope associated to context " + context);
            }
        }
        return false;
    }

    @Override
    public int getSize(Context context) throws InvalidContextException, InternalCacheEngineException {
        if (context.isCacheOn()) {
            try {
                return this.cache.getSize(context.getId());
            }
            catch (InvalidScopeException e) {
                throw new InvalidContextException("No scope associated to context " + context);
            }
        }
        return 0;
    }

    @Override
    public Collection<?> getKeys(Context context) throws InvalidContextException, InternalCacheEngineException {
        if (context.isCacheOn()) {
            try {
                return this.cache.getKeys(context.getId());
            }
            catch (InvalidScopeException e) {
                throw new InvalidContextException("No scope associated to context " + context);
            }
        }
        return Collections.emptyList();
    }

    @Override
    public boolean hasKey(Context context, Object key) throws InvalidContextException, InternalCacheEngineException {
        if (context.isCacheOn()) {
            try {
                return this.cache.hasKey(context.getId(), key);
            }
            catch (InvalidScopeException e) {
                throw new InvalidContextException("No scope associated to context " + context);
            }
        }
        return false;
    }

    @Override
    public CacheItem getItem(Context context, Object key) throws InvalidContextException, InternalCacheEngineException {
        if (context.isCacheOn()) {
            try {
                return this.cache.getWithDependencyCheck(context.getId(), key);
            }
            catch (InvalidScopeException e) {
                throw new InvalidContextException("No scope associated to context " + context);
            }
        }
        return null;
    }

    @Override
    public Object get(Context context, Object key) throws InvalidContextException, InternalCacheEngineException {
        if (context.isCacheOn()) {
            try {
                CacheItem item = this.cache.getWithDependencyCheck(context.getId(), key);
                if (item != null) {
                    return item.getValue();
                }
                return null;
            }
            catch (InvalidScopeException e) {
                throw new InvalidContextException("No scope associated to context " + context);
            }
        }
        return null;
    }

    @Override
    public void put(Context context, Object key, Object value) throws InvalidContextException, InternalCacheEngineException {
        if (context.isCacheOn()) {
            try {
                this.cache.put(context.getId(), key, value);
            }
            catch (InvalidScopeException e) {
                throw new InvalidContextException("No scope associated to context " + context);
            }
        }
    }

    @Override
    public void put(Context context, Object key, Object value, List<Object> dependencyKeys) throws InvalidScopeException, InternalCacheEngineException {
        if (context.isCacheOn()) {
            try {
                this.cache.put(context.getId(), key, value, dependencyKeys);
            }
            catch (InvalidScopeException e) {
                throw new InvalidContextException("No scope associated to context " + context);
            }
        }
    }

    @Override
    public void put(Context context, Object key, Object value, CachingOptions cachingOptions, CacheLoader loader, Object ... loaderParams) throws InvalidContextException, InternalCacheEngineException {
        if (context.isCacheOn() && cachingOptions.doCaching()) {
            try {
                this.cache.put(context.getId(), key, value, cachingOptions.getExpireAfter(), cachingOptions.getRefreshFrequency(), loader, loaderParams);
            }
            catch (InvalidScopeException e) {
                throw new InvalidContextException("No scope associated to context " + context);
            }
        }
    }

    @Override
    public void put(Context context, Object key, Object value, List<Object> dependencyKeys, CachingOptions cachingOptions, CacheLoader loader, Object ... loaderParams) throws InvalidContextException, InternalCacheEngineException {
        if (context.isCacheOn() && cachingOptions.doCaching()) {
            try {
                this.cache.put(context.getId(), key, value, dependencyKeys, cachingOptions.getExpireAfter(), cachingOptions.getRefreshFrequency(), loader, loaderParams);
            }
            catch (InvalidScopeException e) {
                throw new InvalidContextException("No scope associated to context " + context);
            }
        }
    }

    @Override
    public boolean remove(Context context, Object key) throws InvalidContextException, InternalCacheEngineException {
        if (context.isCacheOn()) {
            try {
                return this.cache.remove(context.getId(), key);
            }
            catch (InvalidScopeException e) {
                throw new InvalidContextException("No scope associated to context " + context);
            }
        }
        return false;
    }

    @Override
    public void clearScope(Context context) throws InvalidContextException, InternalCacheEngineException {
        if (context.isCacheOn()) {
            try {
                this.cache.clearScope(context.getId());
            }
            catch (InvalidScopeException e) {
                throw new InvalidContextException("No scope associated to context " + context);
            }
        }
    }
}

