/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.core.util.cache.impl;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.craftercms.commons.lang.Callback;
import org.craftercms.core.cache.CacheLoader;
import org.craftercms.core.service.CacheService;
import org.craftercms.core.service.CachingOptions;
import org.craftercms.core.service.Context;
import org.craftercms.core.util.CacheUtils;
import org.craftercms.core.util.cache.CacheTemplate;
import org.springframework.beans.factory.annotation.Required;

public class DefaultCacheTemplate
implements CacheTemplate {
    private static final Log logger = LogFactory.getLog(DefaultCacheTemplate.class);
    private CacheService cacheService;

    @Override
    public CacheService getCacheService() {
        return this.cacheService;
    }

    @Required
    public void setCacheService(CacheService cacheService) {
        this.cacheService = cacheService;
    }

    @Override
    public Object getKey(Object ... keyElements) {
        return CacheUtils.generateKey(keyElements);
    }

    @Override
    public <T> T getObject(Context context, Callback<T> callback, Object ... keyElements) {
        return this.getObject(context, (CachingOptions)null, callback, keyElements);
    }

    @Override
    public <T> T getObject(Context context, CachingOptions cachingOptions, Callback<T> callback, Object ... keyElements) {
        Object key = this.getKey(keyElements);
        Object obj = this.doGet(context, callback, key);
        if (obj == null && (obj = callback.execute()) != null) {
            if (cachingOptions == null) {
                cachingOptions = CachingOptions.DEFAULT_CACHING_OPTIONS;
            }
            obj = this.doPut(context, cachingOptions, callback, key, obj);
        }
        return obj;
    }

    protected <T> T doGet(Context context, Callback<T> callback, Object key) {
        Object obj = null;
        try {
            obj = this.cacheService.get(context, key);
        }
        catch (Exception e) {
            this.logGetFailure(context, callback, key, e);
        }
        return (T)obj;
    }

    protected <T> T doPut(Context context, CachingOptions cachingOptions, Callback<T> callback, Object key, T obj) {
        try {
            CacheLoader loader = this.getCacheLoader(callback, cachingOptions.getRefreshFrequency());
            this.cacheService.put(context, key, obj, cachingOptions, loader, new Object[0]);
        }
        catch (Exception e) {
            this.logPutFailure(context, callback, key, obj, e);
        }
        return obj;
    }

    protected <T> CacheLoader getCacheLoader(final Callback<T> callback, long refreshFrequency) {
        if (refreshFrequency != 0L) {
            return new CacheLoader(){

                @Override
                public Object load(Object ... parameters) throws Exception {
                    return callback.execute();
                }
            };
        }
        return null;
    }

    protected void logGetFailure(Context context, Callback<?> callback, Object key, Exception e) {
        logger.error((Object)("Unable to retrieve cached object: key='" + key + "', context=" + context + ", callback=" + callback), (Throwable)e);
    }

    protected void logPutFailure(Context context, Callback<?> callback, Object key, Object obj, Exception e) {
        logger.error((Object)("Unable to put cache object: key='" + key + "', context=" + context + ", obj=" + obj + ", callback=" + callback), (Throwable)e);
    }
}

