/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.core.util.url.impl;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.craftercms.core.util.url.ContentBundleUrl;
import org.craftercms.core.util.url.ContentBundleUrlParser;
import org.craftercms.core.util.url.impl.ContentBundleUrlImpl;
import org.springframework.beans.factory.annotation.Required;

public class RegexBasedContentBundleUrlParser
implements ContentBundleUrlParser {
    private int prefixGroup;
    private int baseNameAndExtensionTokenGroup;
    private int suffixGroup;
    private Pattern pattern;

    @Required
    public void setPrefixGroup(int prefixGroup) {
        this.prefixGroup = prefixGroup;
    }

    @Required
    public void setBaseNameAndExtensionTokenGroup(int baseNameAndExtensionTokenGroup) {
        this.baseNameAndExtensionTokenGroup = baseNameAndExtensionTokenGroup;
    }

    @Required
    public void setSuffixGroup(int suffixGroup) {
        this.suffixGroup = suffixGroup;
    }

    @Required
    public void setPattern(Pattern pattern) {
        this.pattern = pattern;
    }

    @Override
    public ContentBundleUrl getContentBundleUrl(String rawUrl) {
        ContentBundleUrlImpl parsedUrl = new ContentBundleUrlImpl();
        Matcher matcher = this.pattern.matcher(rawUrl);
        if (matcher.matches()) {
            try {
                parsedUrl.setPrefix(matcher.group(this.prefixGroup));
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
            try {
                parsedUrl.setBaseNameAndExtensionToken(matcher.group(this.baseNameAndExtensionTokenGroup));
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
            try {
                parsedUrl.setSuffix(matcher.group(this.suffixGroup));
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
        }
        return parsedUrl;
    }
}

