/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.core.xml.mergers.impl.strategies;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.craftercms.core.exception.XmlMergeException;
import org.craftercms.core.service.CachingOptions;
import org.craftercms.core.service.Context;
import org.craftercms.core.service.Item;
import org.craftercms.core.util.url.ContentBundleUrl;
import org.craftercms.core.util.url.ContentBundleUrlParser;
import org.craftercms.core.xml.mergers.DescriptorMergeStrategy;
import org.craftercms.core.xml.mergers.DescriptorMergeStrategyResolver;
import org.craftercms.core.xml.mergers.MergeableDescriptor;
import org.dom4j.Document;
import org.springframework.beans.factory.annotation.Required;

public class ContentBundleMergeStrategy
implements DescriptorMergeStrategy {
    private static final Log logger = LogFactory.getLog(DescriptorMergeStrategy.class);
    private ContentBundleUrlParser urlParser;
    private String baseDelimiter;
    private DescriptorMergeStrategyResolver baseMergeStrategyResolver;
    private DescriptorMergeStrategy regularMergeStrategy;

    @Required
    public void setUrlParser(ContentBundleUrlParser urlParser) {
        this.urlParser = urlParser;
    }

    @Required
    public void setBaseDelimiter(String baseDelimiter) {
        this.baseDelimiter = baseDelimiter;
    }

    @Required
    public void setBaseMergeStrategyResolver(DescriptorMergeStrategyResolver baseMergeStrategyResolver) {
        this.baseMergeStrategyResolver = baseMergeStrategyResolver;
    }

    @Required
    public void setRegularMergeStrategy(DescriptorMergeStrategy regularMergeStrategy) {
        this.regularMergeStrategy = regularMergeStrategy;
    }

    @Override
    public List<MergeableDescriptor> getDescriptors(Context context, CachingOptions cachingOptions, String mainDescriptorUrl, Document mainDescriptorDom) throws XmlMergeException {
        return this.getDescriptors(context, cachingOptions, mainDescriptorUrl, mainDescriptorDom, false);
    }

    @Override
    public List<MergeableDescriptor> getDescriptors(Context context, CachingOptions cachingOptions, String mainDescriptorUrl, Document mainDescriptorDom, boolean mainDescriptorOptional) throws XmlMergeException {
        ArrayList<MergeableDescriptor> descriptors = new ArrayList<MergeableDescriptor>();
        ContentBundleUrl parsedUrl = this.urlParser.getContentBundleUrl(mainDescriptorUrl);
        String prefix = parsedUrl.getPrefix();
        String baseNameAndExtensionToken = parsedUrl.getBaseNameAndExtensionToken();
        String suffix = parsedUrl.getSuffix();
        if (prefix.length() < mainDescriptorUrl.length()) {
            List<MergeableDescriptor> tmp;
            String baseName = baseNameAndExtensionToken;
            int delimiterIdx = baseName.lastIndexOf(this.baseDelimiter);
            boolean baseFound = false;
            while (delimiterIdx > 0 && !baseFound) {
                baseName = baseName.substring(0, delimiterIdx);
                String baseDescriptor = prefix + baseName + suffix;
                Document baseDescriptorDom = this.getDescriptorDom(context, cachingOptions, baseDescriptor);
                if (baseDescriptorDom != null) {
                    baseFound = true;
                } else if (logger.isDebugEnabled()) {
                    logger.debug((Object)("No base descriptor " + baseDescriptor + " was found"));
                }
                if (baseFound) {
                    DescriptorMergeStrategy baseMergeStrategy = this.baseMergeStrategyResolver.getStrategy(baseDescriptor, baseDescriptorDom);
                    if (baseMergeStrategy == null) {
                        throw new XmlMergeException("No merge strategy for descriptor " + baseDescriptor);
                    }
                    tmp = baseMergeStrategy.getDescriptors(context, cachingOptions, baseDescriptor, baseDescriptorDom, true);
                    descriptors.addAll(tmp);
                    continue;
                }
                delimiterIdx = baseName.lastIndexOf(this.baseDelimiter);
            }
            String noPrefix = mainDescriptorUrl.substring(prefix.length(), mainDescriptorUrl.length());
            tmp = this.regularMergeStrategy.getDescriptors(context, cachingOptions, noPrefix, mainDescriptorDom, mainDescriptorOptional);
            for (MergeableDescriptor descriptor : tmp) {
                descriptor.setUrl(prefix + descriptor.getUrl());
                if (descriptors.contains(descriptor)) continue;
                descriptors.add(descriptor);
            }
        } else {
            descriptors.add(new MergeableDescriptor(mainDescriptorUrl, mainDescriptorOptional));
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Final merge list for " + mainDescriptorUrl + ": " + descriptors));
        }
        return descriptors;
    }

    protected Document getDescriptorDom(Context context, CachingOptions cachingOptions, String url) {
        Item item = context.getStoreAdapter().findItem(context, cachingOptions, url, true);
        if (item != null) {
            return item.getDescriptorDom();
        }
        return null;
    }
}

