/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.profile.api;

import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.bson.types.ObjectId;
import org.craftercms.commons.jackson.mvc.annotations.Exclude;

public class Profile {
    private ObjectId _id;
    private String username;
    @Exclude
    private String password;
    private String email;
    private boolean verified;
    private boolean enabled;
    private Date createdOn;
    private Date lastModified;
    private String tenant;
    private Set<String> roles;
    private Map<String, Object> attributes;
    @Exclude
    private int failedLoginAttempts;
    @Exclude
    private Date lastFailedLogin;

    public ObjectId getId() {
        return this._id;
    }

    public void setId(ObjectId id) {
        this._id = id;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public boolean isVerified() {
        return this.verified;
    }

    public void setVerified(boolean verified) {
        this.verified = verified;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public Date getCreatedOn() {
        return this.createdOn;
    }

    public void setCreatedOn(Date createdOn) {
        this.createdOn = createdOn;
    }

    public Date getLastModified() {
        return this.lastModified;
    }

    public void setLastModified(Date lastModified) {
        this.lastModified = lastModified;
    }

    public String getTenant() {
        return this.tenant;
    }

    public void setTenant(String tenant) {
        this.tenant = tenant;
    }

    public boolean hasRole(String role) {
        return this.getRoles().contains(role);
    }

    public int getFailedLoginAttempts() {
        return this.failedLoginAttempts;
    }

    public void setFailedLoginAttempts(int failedLoginAttempts) {
        this.failedLoginAttempts = failedLoginAttempts;
    }

    public Date getLastFailedLogin() {
        return this.lastFailedLogin;
    }

    public void setLastFailedLogin(Date lastFailedLogin) {
        this.lastFailedLogin = lastFailedLogin;
    }

    public boolean hasAnyRole(String ... roles) {
        for (String role : roles) {
            if (!this.hasRole(role)) continue;
            return true;
        }
        return false;
    }

    public boolean hasAnyRole(Collection<String> roles) {
        for (String role : roles) {
            if (!this.hasRole(role)) continue;
            return true;
        }
        return false;
    }

    public Set<String> getRoles() {
        if (this.roles == null) {
            this.roles = new HashSet<String>();
        }
        return this.roles;
    }

    public void setRoles(Set<String> roles) {
        this.roles = roles;
    }

    public Map<String, Object> getAttributes() {
        if (this.attributes == null) {
            this.attributes = new HashMap<String, Object>();
        }
        return this.attributes;
    }

    public <T> T getAttribute(String name) {
        return (T)this.getAttributes().get(name);
    }

    public void setAttributes(Map<String, Object> attributes) {
        this.attributes = attributes;
    }

    public void setAttribute(String name, Object value) {
        this.getAttributes().put(name, value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Profile profile = (Profile)o;
        return this._id.equals((Object)profile._id);
    }

    public int hashCode() {
        return this._id.hashCode();
    }

    public String toString() {
        return "Profile{id=" + this._id + ", username='" + this.username + '\'' + ", password='" + this.password + '\'' + ", email='" + this.email + '\'' + ", verified=" + this.verified + ", enabled=" + this.enabled + ", createdOn=" + this.createdOn + ", lastModified=" + this.lastModified + ", tenant='" + this.tenant + '\'' + ", roles=" + this.roles + ", attributes=" + this.attributes + '}';
    }

    public void increaseFailedLoginAttempts() {
        ++this.failedLoginAttempts;
    }
}

