/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.search.batch.impl;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.craftercms.commons.lang.RegexUtils;
import org.craftercms.core.service.ContentStoreService;
import org.craftercms.core.service.Context;
import org.craftercms.search.batch.BatchIndexer;
import org.craftercms.search.batch.UpdateDetail;
import org.craftercms.search.batch.UpdateSet;
import org.craftercms.search.batch.UpdateStatus;
import org.craftercms.search.batch.exception.BatchIndexingException;
import org.craftercms.search.metadata.impl.AbstractMetadataCollector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractBatchIndexer
extends AbstractMetadataCollector
implements BatchIndexer {
    private static final Logger logger = LoggerFactory.getLogger(AbstractBatchIndexer.class);
    protected List<String> includePathPatterns;
    protected List<String> excludePathPatterns;

    public void setIncludePathPatterns(List<String> includePathPatterns) {
        this.includePathPatterns = includePathPatterns;
    }

    public void setExcludePathPatterns(List<String> excludePathPatterns) {
        this.excludePathPatterns = excludePathPatterns;
    }

    @Override
    public void updateIndex(String indexId, String siteName, ContentStoreService contentStoreService, Context context, UpdateSet updateSet, UpdateStatus updateStatus) throws BatchIndexingException {
        for (String path : updateSet.getUpdatePaths()) {
            if (!this.include(path)) continue;
            try {
                Map<String, String> metadata = this.collectMetadata(path, contentStoreService, context);
                this.doSingleFileUpdate(indexId, siteName, contentStoreService, context, path, false, updateSet.getUpdateDetail(path), updateStatus, metadata);
            }
            catch (Exception e) {
                logger.error("Error while trying to perform update of file {}:{}", new Object[]{siteName, path, e});
                updateStatus.addFailedUpdate(path);
            }
        }
        for (String path : updateSet.getDeletePaths()) {
            if (!this.include(path)) continue;
            try {
                this.doSingleFileUpdate(indexId, siteName, contentStoreService, context, path, true, null, updateStatus, Collections.emptyMap());
            }
            catch (Exception e) {
                logger.error("Error while trying to perform delete of file {}:{}", new Object[]{siteName, path, e});
                updateStatus.addFailedDelete(path);
            }
        }
    }

    protected boolean include(String path) {
        return !(!CollectionUtils.isEmpty(this.includePathPatterns) && !RegexUtils.matchesAny((String)path, this.includePathPatterns) || !CollectionUtils.isEmpty(this.excludePathPatterns) && RegexUtils.matchesAny((String)path, this.excludePathPatterns));
    }

    protected abstract void doSingleFileUpdate(String var1, String var2, ContentStoreService var3, Context var4, String var5, boolean var6, UpdateDetail var7, UpdateStatus var8, Map<String, String> var9) throws Exception;
}

