/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.search.batch.impl;

import java.util.List;
import java.util.Map;
import javax.activation.FileTypeMap;
import org.craftercms.core.service.Content;
import org.craftercms.core.service.ContentStoreService;
import org.craftercms.core.service.Context;
import org.craftercms.search.batch.UpdateDetail;
import org.craftercms.search.batch.UpdateStatus;
import org.craftercms.search.batch.impl.AbstractBatchIndexer;
import org.craftercms.search.batch.utils.IndexingUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.mail.javamail.ConfigurableMimeFileTypeMap;

public abstract class AbstractBinaryFileBatchIndexer
extends AbstractBatchIndexer {
    private static final Logger logger = LoggerFactory.getLogger(AbstractBinaryFileBatchIndexer.class);
    protected List<String> supportedMimeTypes;
    protected FileTypeMap mimeTypesMap = new ConfigurableMimeFileTypeMap();
    protected long maxFileSize;

    public void setSupportedMimeTypes(List<String> supportedMimeTypes) {
        this.supportedMimeTypes = supportedMimeTypes;
    }

    @Required
    public void setMaxFileSize(long maxFileSize) {
        this.maxFileSize = maxFileSize;
    }

    @Override
    protected void doSingleFileUpdate(String indexId, String siteName, ContentStoreService contentStoreService, Context context, String path, boolean delete, UpdateDetail updateDetail, UpdateStatus updateStatus, Map<String, String> metadata) {
        if (delete) {
            this.doDelete(indexId, siteName, path, updateStatus);
        } else {
            Content binaryContent = contentStoreService.getContent(context, path);
            if (binaryContent != null && binaryContent.getLength() > 0L) {
                if (binaryContent.getLength() > this.maxFileSize) {
                    logger.warn("Skipping large binary file @ {}", (Object)path);
                } else {
                    this.doUpdateContent(indexId, siteName, path, binaryContent, updateDetail, updateStatus, metadata);
                }
            }
        }
    }

    protected abstract void doDelete(String var1, String var2, String var3, UpdateStatus var4);

    protected abstract void doUpdateContent(String var1, String var2, String var3, Content var4, UpdateDetail var5, UpdateStatus var6, Map<String, String> var7);

    @Override
    protected boolean include(String path) {
        if (super.include(path)) {
            return IndexingUtils.isMimeTypeSupported(this.mimeTypesMap, this.supportedMimeTypes, path);
        }
        return false;
    }
}

