/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.search.batch.impl;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.activation.FileTypeMap;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.craftercms.commons.file.stores.RemoteFile;
import org.craftercms.commons.file.stores.RemoteFileResolver;
import org.craftercms.commons.lang.RegexUtils;
import org.craftercms.core.processors.ItemProcessor;
import org.craftercms.core.processors.impl.ItemProcessorPipeline;
import org.craftercms.core.service.Content;
import org.craftercms.core.service.ContentStoreService;
import org.craftercms.core.service.Context;
import org.craftercms.search.batch.BatchIndexer;
import org.craftercms.search.batch.UpdateDetail;
import org.craftercms.search.batch.UpdateSet;
import org.craftercms.search.batch.UpdateStatus;
import org.craftercms.search.batch.exception.BatchIndexingException;
import org.craftercms.search.batch.utils.IndexingUtils;
import org.craftercms.search.metadata.impl.AbstractMetadataCollector;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.core.io.Resource;
import org.springframework.mail.javamail.ConfigurableMimeFileTypeMap;

public abstract class AbstractBinaryFileWithMetadataBatchIndexer<T>
extends AbstractMetadataCollector
implements BatchIndexer {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    public static final String DEFAULT_METADATA_PATH_FIELD_NAME = "metadataPath";
    public static final String DEFAULT_LOCAL_ID_FIELD_NAME = "localId";
    protected List<String> supportedMimeTypes;
    protected FileTypeMap mimeTypesMap = new ConfigurableMimeFileTypeMap();
    protected RemoteFileResolver remoteFileResolver;
    protected ItemProcessor itemProcessor;
    protected List<String> metadataPathPatterns;
    protected List<String> binaryPathPatterns;
    protected List<String> remoteBinaryPathPatterns;
    protected List<String> childBinaryPathPatterns;
    protected List<String> referenceXPaths;
    protected List<String> includePropertyPatterns;
    protected List<String> excludePropertyPatterns;
    @Deprecated
    protected List<String> excludeMetadataProperties;
    protected String metadataPathFieldName = "metadataPath";
    protected String localIdFieldName = "localId";
    protected long maxFileSize;

    public void setSupportedMimeTypes(List<String> supportedMimeTypes) {
        this.supportedMimeTypes = supportedMimeTypes;
    }

    public void setRemoteFileResolver(RemoteFileResolver remoteFileResolver) {
        this.remoteFileResolver = remoteFileResolver;
    }

    public void setItemProcessor(ItemProcessor itemProcessor) {
        this.itemProcessor = itemProcessor;
    }

    public void setItemProcessors(List<ItemProcessor> itemProcessors) {
        this.itemProcessor = new ItemProcessorPipeline(itemProcessors);
    }

    public void setMetadataPathPatterns(List<String> metadataPathPatterns) {
        this.metadataPathPatterns = metadataPathPatterns;
    }

    public void setBinaryPathPatterns(List<String> binaryPathPatterns) {
        this.binaryPathPatterns = binaryPathPatterns;
    }

    public void setRemoteBinaryPathPatterns(List<String> remoteBinaryPathPatterns) {
        this.remoteBinaryPathPatterns = remoteBinaryPathPatterns;
    }

    public void setChildBinaryPathPatterns(List<String> childBinaryPathPatterns) {
        this.childBinaryPathPatterns = childBinaryPathPatterns;
    }

    public void setReferenceXPaths(List<String> referenceXPaths) {
        this.referenceXPaths = referenceXPaths;
    }

    public void setIncludePropertyPatterns(List<String> includePropertyPatterns) {
        this.includePropertyPatterns = includePropertyPatterns;
    }

    public void setExcludePropertyPatterns(List<String> excludePropertyPatterns) {
        this.excludePropertyPatterns = excludePropertyPatterns;
    }

    @Deprecated
    public void setExcludeMetadataProperties(List<String> excludeMetadataProperties) {
        this.excludeMetadataProperties = excludeMetadataProperties;
    }

    public void setMetadataPathFieldName(String metadataPathFieldName) {
        this.metadataPathFieldName = metadataPathFieldName;
    }

    public void setLocalIdFieldName(String localIdFieldName) {
        this.localIdFieldName = localIdFieldName;
    }

    @Required
    public void setMaxFileSize(long maxFileSize) {
        this.maxFileSize = maxFileSize;
    }

    @Override
    public void updateIndex(String indexId, String siteName, ContentStoreService contentStoreService, Context context, UpdateSet updateSet, UpdateStatus updateStatus) throws BatchIndexingException {
        this.doUpdates(indexId, siteName, contentStoreService, context, updateSet, updateStatus);
        this.doDeletes(indexId, siteName, contentStoreService, context, updateSet.getDeletePaths(), updateStatus);
    }

    protected void doUpdates(String indexId, String siteName, ContentStoreService contentStoreService, Context context, UpdateSet updateSet, UpdateStatus updateStatus) {
        List<String> updatePaths = updateSet.getUpdatePaths();
        LinkedHashSet<String> metadataUpdatePaths = new LinkedHashSet<String>();
        LinkedHashSet<String> binaryUpdatePaths = new LinkedHashSet<String>();
        for (String path : updatePaths) {
            if (this.isMetadata(path)) {
                metadataUpdatePaths.add(path);
                continue;
            }
            if (!this.isBinary(path)) continue;
            binaryUpdatePaths.add(path);
        }
        for (String metadataPath : metadataUpdatePaths) {
            List<String> newBinaryPaths = Collections.emptyList();
            List<String> previousBinaryPaths = this.searchBinaryPathsFromMetadataPath(indexId, siteName, metadataPath);
            Document metadataDoc = this.loadMetadata(contentStoreService, context, siteName, metadataPath);
            if (metadataDoc != null) {
                newBinaryPaths = this.getBinaryFilePaths(metadataDoc);
            }
            this.updatePreviousBinaries(indexId, siteName, metadataPath, previousBinaryPaths, newBinaryPaths, binaryUpdatePaths, context, contentStoreService, updateSet.getUpdateDetail(metadataPath), updateStatus);
            if (!CollectionUtils.isNotEmpty(newBinaryPaths)) continue;
            T metadata = this.extractMetadata(metadataPath, metadataDoc);
            for (String newBinaryPath : newBinaryPaths) {
                binaryUpdatePaths.remove(newBinaryPath);
                Map<String, String> additionalFields = this.collectMetadata(metadataPath, contentStoreService, context);
                metadata = this.mergeMetadata(metadata, additionalFields);
                this.updateBinaryWithMetadata(indexId, siteName, contentStoreService, context, newBinaryPath, metadata, updateSet.getUpdateDetail(metadataPath), updateStatus);
            }
        }
        for (String binaryPath : binaryUpdatePaths) {
            String metadataPath = this.searchMetadataPathFromBinaryPath(indexId, siteName, binaryPath);
            if (StringUtils.isNotEmpty((CharSequence)metadataPath)) {
                Document metadataDoc = this.loadMetadata(contentStoreService, context, siteName, metadataPath);
                if (metadataDoc == null) continue;
                T metadata = this.extractMetadata(metadataPath, metadataDoc);
                Map<String, String> additionalFields = this.collectMetadata(metadataPath, contentStoreService, context);
                metadata = this.mergeMetadata(metadata, additionalFields);
                this.updateBinaryWithMetadata(indexId, siteName, contentStoreService, context, binaryPath, metadata, updateSet.getUpdateDetail(metadataPath), updateStatus);
                continue;
            }
            this.updateBinary(indexId, siteName, contentStoreService, context, binaryPath, updateSet.getUpdateDetail(binaryPath), updateStatus);
        }
    }

    protected void updatePreviousBinaries(String indexId, String siteName, String metadataPath, List<String> previousBinaryPaths, Collection<String> newBinaryPaths, Set<String> binaryUpdatePaths, Context context, ContentStoreService contentStoreService, UpdateDetail updateDetail, UpdateStatus updateStatus) {
        if (CollectionUtils.isNotEmpty(previousBinaryPaths)) {
            for (String previousBinaryPath : previousBinaryPaths) {
                if (!CollectionUtils.isEmpty(newBinaryPaths) && newBinaryPaths.contains(previousBinaryPath)) continue;
                binaryUpdatePaths.remove(previousBinaryPath);
                if (this.isChildBinary(previousBinaryPath)) {
                    this.logger.debug("Reference of child binary {} removed from  parent {}. Deleting binary from index...", (Object)previousBinaryPath, (Object)metadataPath);
                    this.doDelete(indexId, siteName, previousBinaryPath, updateStatus);
                    continue;
                }
                this.logger.debug("Reference of binary {} removed from {}. Reindexing without metadata...", (Object)previousBinaryPath, (Object)metadataPath);
                this.updateBinary(indexId, siteName, contentStoreService, context, previousBinaryPath, updateDetail, updateStatus);
            }
        }
    }

    protected abstract void doDelete(String var1, String var2, String var3, UpdateStatus var4);

    protected void doDeletes(String indexId, String siteName, ContentStoreService contentStoreService, Context context, List<String> deletePaths, UpdateStatus updateStatus) {
        for (String path : deletePaths) {
            if (this.isMetadata(path)) {
                List<String> binaryPaths = this.searchBinaryPathsFromMetadataPath(indexId, siteName, path);
                for (String binaryPath : binaryPaths) {
                    if (this.isChildBinary(binaryPath)) {
                        this.logger.debug("Parent of binary {} deleted. Deleting child binary too", (Object)binaryPath);
                        this.doDelete(indexId, siteName, binaryPath, updateStatus);
                        continue;
                    }
                    this.logger.debug("Metadata with reference of binary {} deleted. Reindexing without metadata...", (Object)binaryPath);
                    this.updateBinary(indexId, siteName, contentStoreService, context, binaryPath, null, updateStatus);
                }
                continue;
            }
            if (!this.isBinary(path)) continue;
            this.doDelete(indexId, siteName, path, updateStatus);
        }
    }

    protected boolean isMetadata(String path) {
        return RegexUtils.matchesAny((String)path, this.metadataPathPatterns);
    }

    protected boolean isBinary(String path) {
        return RegexUtils.matchesAny((String)path, this.binaryPathPatterns) && IndexingUtils.isMimeTypeSupported(this.mimeTypesMap, this.supportedMimeTypes, path);
    }

    protected boolean isRemoteBinary(String path) {
        return RegexUtils.matchesAny((String)path, this.remoteBinaryPathPatterns);
    }

    protected boolean isChildBinary(String path) {
        return RegexUtils.matchesAny((String)path, this.childBinaryPathPatterns);
    }

    protected abstract List<String> searchBinaryPathsFromMetadataPath(String var1, String var2, String var3);

    protected abstract String searchMetadataPathFromBinaryPath(String var1, String var2, String var3);

    protected Document loadMetadata(ContentStoreService contentStoreService, Context context, String siteName, String metadataPath) {
        try {
            Document metadataDoc = contentStoreService.getItem(context, null, metadataPath, this.itemProcessor).getDescriptorDom();
            if (metadataDoc != null) {
                return metadataDoc;
            }
            this.logger.error("File {}:{} is not a metadata XML descriptor", (Object)siteName, (Object)metadataPath);
        }
        catch (Exception e) {
            this.logger.error("Error retrieving metadata file @ {}:{}", new Object[]{siteName, metadataPath, e});
        }
        return null;
    }

    protected Collection<String> getBinaryFilePaths(Document document) {
        if (CollectionUtils.isNotEmpty(this.referenceXPaths)) {
            LinkedHashSet<String> binaryPaths = new LinkedHashSet<String>();
            for (String refXpath : this.referenceXPaths) {
                List references = document.selectNodes(refXpath);
                if (!CollectionUtils.isNotEmpty((Collection)references)) continue;
                for (Node reference : references) {
                    String referenceValue = reference.getText();
                    if (!StringUtils.isNotBlank((CharSequence)referenceValue) || !IndexingUtils.isMimeTypeSupported(this.mimeTypesMap, this.supportedMimeTypes, referenceValue)) continue;
                    binaryPaths.add(referenceValue);
                }
            }
            return binaryPaths;
        }
        return null;
    }

    protected void updateBinaryWithMetadata(String indexId, String siteName, ContentStoreService contentStoreService, Context context, String binaryPath, T metadata, UpdateDetail updateDetail, UpdateStatus updateStatus) {
        try {
            if (this.remoteFileResolver != null && this.isRemoteBinary(binaryPath)) {
                this.logger.debug("Indexing remote file {}", (Object)binaryPath);
                RemoteFile remoteFile = this.remoteFileResolver.resolve(binaryPath);
                if (remoteFile.getContentLength() > this.maxFileSize) {
                    this.logger.warn("Skipping large binary file @ {}", (Object)binaryPath);
                } else {
                    this.doUpdateContent(indexId, siteName, binaryPath, remoteFile.toResource(), metadata, updateDetail, updateStatus);
                }
            } else {
                Content binaryContent = contentStoreService.findContent(context, binaryPath);
                if (binaryContent == null) {
                    this.logger.debug("No binary file found @ {}:{}. Empty content will be used for the update", (Object)siteName, (Object)binaryPath);
                    binaryContent = new EmptyContent();
                }
                if (binaryContent.getLength() > this.maxFileSize) {
                    this.logger.warn("Skipping large binary file @ {}", (Object)binaryPath);
                } else {
                    this.doUpdateContent(indexId, siteName, binaryPath, binaryContent, metadata, updateDetail, updateStatus);
                }
            }
        }
        catch (Exception e) {
            this.logger.error("Error when trying to send index update with metadata for binary file {}:{}", new Object[]{siteName, binaryPath, e});
        }
    }

    protected abstract void doUpdateContent(String var1, String var2, String var3, Resource var4, T var5, UpdateDetail var6, UpdateStatus var7);

    protected abstract void doUpdateContent(String var1, String var2, String var3, Content var4, T var5, UpdateDetail var6, UpdateStatus var7);

    protected void updateBinary(String indexId, String siteName, ContentStoreService contentStoreService, Context context, String binaryPath, UpdateDetail updateDetail, UpdateStatus updateStatus) {
        try {
            if (this.remoteFileResolver != null && this.isRemoteBinary(binaryPath)) {
                this.logger.info("Indexing remote file {}", (Object)binaryPath);
                RemoteFile remoteFile = this.remoteFileResolver.resolve(binaryPath);
                if (remoteFile.getContentLength() > this.maxFileSize) {
                    this.logger.warn("Skipping large binary file @ {}", (Object)binaryPath);
                } else {
                    this.doUpdateContent(indexId, siteName, binaryPath, remoteFile.toResource(), updateDetail, updateStatus);
                }
            } else {
                Content binaryContent = contentStoreService.findContent(context, binaryPath);
                if (binaryContent != null && binaryContent.getLength() > 0L) {
                    if (binaryContent.getLength() > this.maxFileSize) {
                        this.logger.warn("Skipping large binary file @ {}", (Object)binaryPath);
                    } else {
                        Map<String, String> metadata = this.collectMetadata(binaryPath, contentStoreService, context);
                        this.doUpdateContent(indexId, siteName, binaryPath, binaryContent, updateDetail, updateStatus, metadata);
                    }
                } else {
                    this.logger.debug("No binary file found @ {}:{}. Skipping update", (Object)siteName, (Object)binaryPath);
                }
            }
        }
        catch (Exception e) {
            this.logger.error("Error when trying to send index update for binary file {}:{}", new Object[]{siteName, binaryPath, e});
        }
    }

    protected abstract void doUpdateContent(String var1, String var2, String var3, Resource var4, UpdateDetail var5, UpdateStatus var6);

    protected abstract void doUpdateContent(String var1, String var2, String var3, Content var4, UpdateDetail var5, UpdateStatus var6, Map<String, String> var7);

    protected abstract T extractMetadata(String var1, Document var2);

    protected abstract void extractMetadataFromChildren(Element var1, String var2, T var3);

    protected abstract T mergeMetadata(T var1, Object var2);

    protected boolean shouldIncludeProperty(String name) {
        return !(!CollectionUtils.isEmpty(this.includePropertyPatterns) && !RegexUtils.matchesAny((String)name, this.includePropertyPatterns) || !CollectionUtils.isEmpty(this.excludePropertyPatterns) && RegexUtils.matchesAny((String)name, this.excludePropertyPatterns));
    }

    public static class EmptyContent
    implements Content {
        public long getLastModified() {
            return System.currentTimeMillis();
        }

        public long getLength() {
            return 0L;
        }

        public InputStream getInputStream() throws IOException {
            return new ByteArrayInputStream(new byte[0]);
        }
    }
}

