/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.search.batch.impl;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.craftercms.core.exception.CrafterException;
import org.craftercms.core.exception.XmlException;
import org.craftercms.core.processors.ItemProcessor;
import org.craftercms.core.processors.impl.ItemProcessorPipeline;
import org.craftercms.core.service.Content;
import org.craftercms.core.service.ContentStoreService;
import org.craftercms.core.service.Context;
import org.craftercms.core.service.Item;
import org.craftercms.search.batch.UpdateDetail;
import org.craftercms.search.batch.UpdateStatus;
import org.craftercms.search.batch.impl.AbstractBatchIndexer;
import org.dom4j.Document;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractXmlFileBatchIndexer
extends AbstractBatchIndexer {
    private static final Logger logger = LoggerFactory.getLogger(AbstractXmlFileBatchIndexer.class);
    public static final List<String> DEFAULT_INCLUDE_FILENAME_PATTERNS = Collections.singletonList("^.*\\.xml$");
    protected ItemProcessor itemProcessor;

    public AbstractXmlFileBatchIndexer() {
        this.includePathPatterns = DEFAULT_INCLUDE_FILENAME_PATTERNS;
    }

    public void setItemProcessor(ItemProcessor itemProcessor) {
        this.itemProcessor = itemProcessor;
    }

    public void setItemProcessors(List<ItemProcessor> itemProcessors) {
        this.itemProcessor = new ItemProcessorPipeline(itemProcessors);
    }

    @Override
    protected void doSingleFileUpdate(String indexId, String siteName, ContentStoreService contentStoreService, Context context, String path, boolean delete, UpdateDetail updateDetail, UpdateStatus updateStatus, Map<String, String> metadata) {
        if (delete) {
            this.doDelete(indexId, siteName, path, updateStatus);
        } else {
            String xml = this.processXml(siteName, contentStoreService, context, path);
            this.doUpdate(indexId, siteName, path, xml, updateDetail, updateStatus, metadata);
        }
    }

    protected abstract void doDelete(String var1, String var2, String var3, UpdateStatus var4);

    protected abstract void doUpdate(String var1, String var2, String var3, String var4, UpdateDetail var5, UpdateStatus var6, Map<String, String> var7);

    protected String processXml(String siteName, ContentStoreService contentStoreService, Context context, String path) throws CrafterException {
        logger.debug("Processing XML @ {}:{} before indexing", (Object)siteName, (Object)path);
        Item item = contentStoreService.getItem(context, null, path, this.itemProcessor);
        Document doc = item.getDescriptorDom();
        if (doc != null) {
            String xml = this.documentToString(item.getDescriptorDom());
            logger.debug("XML @ {} processed successfully:\n{}:{}", new Object[]{siteName, path, xml});
            return xml;
        }
        throw new XmlException("Item @ " + siteName + ":" + path + " doesn't seem to be an XML file");
    }

    protected String documentToString(Document document) {
        StringWriter stringWriter = new StringWriter();
        OutputFormat format = OutputFormat.createCompactFormat();
        XMLWriter xmlWriter = new XMLWriter((Writer)stringWriter, format);
        try {
            xmlWriter.write(document);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return stringWriter.toString();
    }

    public static class EmptyContent
    implements Content {
        public long getLastModified() {
            return System.currentTimeMillis();
        }

        public long getLength() {
            return 0L;
        }

        public InputStream getInputStream() {
            return new ByteArrayInputStream(new byte[0]);
        }
    }
}

