/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.search.batch.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.craftercms.core.service.Content;
import org.craftercms.search.batch.UpdateDetail;
import org.craftercms.search.batch.UpdateStatus;
import org.craftercms.search.batch.impl.AbstractBinaryFileWithMetadataBatchIndexer;
import org.craftercms.search.batch.utils.CrafterSearchIndexingUtils;
import org.craftercms.search.service.Query;
import org.craftercms.search.service.ResourceAwareSearchService;
import org.craftercms.search.service.SearchService;
import org.craftercms.search.utils.SearchResultUtils;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.core.io.Resource;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

public class BinaryFileWithMetadataBatchIndexer
extends AbstractBinaryFileWithMetadataBatchIndexer<MultiValueMap<String, String>> {
    protected SearchService searchService;

    @Required
    public void setSearchService(SearchService searchService) {
        this.searchService = searchService;
    }

    @Override
    protected void doDelete(String indexId, String siteName, String previousBinaryPath, UpdateStatus updateStatus) {
        CrafterSearchIndexingUtils.doDelete(this.searchService, indexId, siteName, previousBinaryPath, updateStatus);
    }

    @Override
    protected void doUpdateContent(String indexId, String siteName, String binaryPath, Resource resource, MultiValueMap<String, String> metadata, UpdateDetail updateDetail, UpdateStatus updateStatus) {
        CrafterSearchIndexingUtils.doUpdateContent((ResourceAwareSearchService)this.searchService, indexId, siteName, binaryPath, resource, metadata, updateStatus);
    }

    @Override
    protected void doUpdateContent(String indexId, String siteName, String binaryPath, Content content, MultiValueMap<String, String> metadata, UpdateDetail updateDetail, UpdateStatus updateStatus) {
        CrafterSearchIndexingUtils.doUpdateContent(this.searchService, indexId, siteName, binaryPath, content, metadata, updateStatus);
    }

    @Override
    protected void doUpdateContent(String indexId, String siteName, String binaryPath, Resource toResource, UpdateDetail updateDetail, UpdateStatus updateStatus) {
        CrafterSearchIndexingUtils.doUpdateContent((ResourceAwareSearchService)this.searchService, indexId, siteName, binaryPath, toResource, updateStatus);
    }

    @Override
    protected void doUpdateContent(String indexId, String siteName, String binaryPath, Content content, UpdateDetail updateDetail, UpdateStatus updateStatus, Map<String, String> metadata) {
        CrafterSearchIndexingUtils.doUpdateContent(this.searchService, indexId, siteName, binaryPath, content, updateStatus);
    }

    @Override
    protected List<String> searchBinaryPathsFromMetadataPath(String indexId, String siteName, String metadataPath) {
        Query query = this.searchService.createQuery();
        query.setQuery("crafterSite:\"" + siteName + "\" AND metadataPath:\"" + metadataPath + "\"");
        query.setFieldsToReturn(new String[]{this.localIdFieldName});
        Map result = this.searchService.search(indexId, query);
        List documents = SearchResultUtils.getDocuments((Map)result);
        ArrayList<String> binaryPaths = new ArrayList<String>();
        if (CollectionUtils.isNotEmpty((Collection)documents)) {
            for (Map document : documents) {
                String binaryPath = (String)document.get(this.localIdFieldName);
                if (!StringUtils.isNotEmpty((CharSequence)binaryPath)) continue;
                binaryPaths.add(binaryPath);
            }
        }
        return binaryPaths;
    }

    @Override
    protected String searchMetadataPathFromBinaryPath(String indexId, String siteName, String binaryPath) {
        Query query = this.searchService.createQuery();
        query.setQuery("crafterSite:\"" + siteName + "\" AND localId:\"" + binaryPath + "\"");
        query.setFieldsToReturn(new String[]{this.metadataPathFieldName});
        Map result = this.searchService.search(indexId, query);
        List documents = SearchResultUtils.getDocuments((Map)result);
        if (CollectionUtils.isNotEmpty((Collection)documents)) {
            return (String)((Map)documents.get(0)).get(this.metadataPathFieldName);
        }
        return null;
    }

    @Override
    protected MultiValueMap<String, String> extractMetadata(String path, Document document) {
        LinkedMultiValueMap metadata = new LinkedMultiValueMap();
        Element rootElem = document.getRootElement();
        this.extractMetadataFromChildren(rootElem, "", (MultiValueMap<String, String>)metadata);
        this.logger.debug("Extracted metadata: {}", (Object)metadata);
        metadata.set((Object)this.metadataPathFieldName, (Object)path);
        return metadata;
    }

    @Override
    protected void extractMetadataFromChildren(Element element, String key, MultiValueMap<String, String> metadata) {
        Iterator iter = element.nodeIterator();
        while (iter.hasNext()) {
            Node node = (Node)iter.next();
            if (node instanceof Element) {
                StringBuilder childKey = new StringBuilder(key);
                if (childKey.length() > 0) {
                    childKey.append(".");
                }
                childKey.append(node.getName());
                if (!CollectionUtils.isEmpty((Collection)this.excludeMetadataProperties) && this.excludeMetadataProperties.contains(childKey.toString())) continue;
                this.extractMetadataFromChildren((Element)node, childKey.toString(), metadata);
                continue;
            }
            String value = node.getText();
            if (!StringUtils.isNotBlank((CharSequence)value) || !this.shouldIncludeProperty(key)) continue;
            this.logger.debug("Adding value [{}] for property [{}]", (Object)value, (Object)key);
            metadata.add((Object)key, (Object)StringUtils.trim((String)value));
        }
    }

    @Override
    protected MultiValueMap<String, String> mergeMetadata(MultiValueMap<String, String> a, Object b) {
        if (b instanceof Map) {
            a.setAll((Map)b);
        }
        return a;
    }
}

