/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.search.batch.utils;

import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.activation.FileTypeMap;
import org.apache.commons.collections4.CollectionUtils;
import org.craftercms.search.batch.UpdateDetail;
import org.springframework.util.MimeType;

public abstract class IndexingUtils {
    public static final String FIELD_NAME_EDITED_BY = "lastEditedBy";
    public static final String FIELD_NAME_EDITED_ON = "lastEditedOn";

    public static boolean isMimeTypeSupported(FileTypeMap mimeTypesMap, List<String> supportedMimeTypes, String filename) {
        if (mimeTypesMap != null && CollectionUtils.isNotEmpty(supportedMimeTypes)) {
            MimeType mimeType = MimeType.valueOf((String)mimeTypesMap.getContentType(filename.toLowerCase()));
            return supportedMimeTypes.stream().anyMatch(type -> MimeType.valueOf((String)type).isCompatibleWith(mimeType));
        }
        return true;
    }

    public static Map<String, Object> getAdditionalFields(UpdateDetail updateDetail) {
        HashMap<String, String> additionalFields = null;
        if (updateDetail != null) {
            additionalFields = new HashMap<String, String>();
            additionalFields.put(FIELD_NAME_EDITED_BY, updateDetail.getAuthor());
            additionalFields.put(FIELD_NAME_EDITED_ON, DateTimeFormatter.ISO_INSTANT.format(updateDetail.getDate().atZone(ZoneId.of("UTC"))));
        }
        return additionalFields;
    }
}

