/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.search.metadata.impl;

import java.util.Collections;
import java.util.Map;
import org.craftercms.core.service.Content;
import org.craftercms.core.service.ContentStoreService;
import org.craftercms.core.service.Context;
import org.craftercms.search.metadata.impl.AbstractMetadataExtractor;

public class FileSizeMetadataExtractor
extends AbstractMetadataExtractor {
    public static final String DEFAULT_PROPERTY_NAME = "contentLength";
    protected String propertyName = "contentLength";

    public void setPropertyName(String propertyName) {
        this.propertyName = propertyName;
    }

    @Override
    protected boolean isCompatible(String path, ContentStoreService contentStoreService, Context context) {
        return !contentStoreService.getItem(context, path).isFolder();
    }

    @Override
    protected Map<String, String> doExtract(String path, ContentStoreService contentStoreService, Context context) {
        Content content = contentStoreService.getContent(context, path);
        return Collections.singletonMap(this.propertyName, Long.toString(content.getLength()));
    }
}

