/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.core.processors.impl;

import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.craftercms.core.exception.ItemProcessingException;
import org.craftercms.core.processors.ItemProcessor;
import org.craftercms.core.service.CachingOptions;
import org.craftercms.core.service.Context;
import org.craftercms.core.service.Item;
import org.craftercms.core.xml.mergers.DescriptorMergeStrategy;
import org.craftercms.core.xml.mergers.DescriptorMergeStrategyResolver;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class InheritedDescriptorsItemProcessor
implements ItemProcessor {
    protected String inheritsFromElementName;
    protected DescriptorMergeStrategyResolver mergeStrategyResolver;

    public InheritedDescriptorsItemProcessor(String inheritsFromElementName, DescriptorMergeStrategyResolver mergeStrategyResolver) {
        this.inheritsFromElementName = inheritsFromElementName;
        this.mergeStrategyResolver = mergeStrategyResolver;
    }

    public Item process(Context context, CachingOptions cachingOptions, Item item) throws ItemProcessingException {
        List inheritedDescriptors;
        DescriptorMergeStrategy mergeStrategy;
        if (item.getDescriptorDom() != null && (mergeStrategy = this.mergeStrategyResolver.getStrategy(item.getDescriptorUrl(), item.getDescriptorDom())) != null && CollectionUtils.isNotEmpty((Collection)(inheritedDescriptors = mergeStrategy.getDescriptors(context, cachingOptions, item.getDescriptorUrl(), item.getDescriptorDom())))) {
            inheritedDescriptors.stream().filter(descriptor -> !StringUtils.equals((CharSequence)descriptor.getUrl(), (CharSequence)item.getDescriptorUrl())).forEach(descriptor -> {
                Element inheritedFromElement = DocumentHelper.createElement((String)this.inheritsFromElementName);
                inheritedFromElement.setText(descriptor.getUrl());
                item.getDescriptorDom().getRootElement().add(inheritedFromElement);
            });
        }
        return item;
    }
}

