/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.search.batch;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class UpdateStatus {
    protected List<String> successfulUpdates = new ArrayList<String>();
    protected List<String> successfulDeletes = new ArrayList<String>();
    protected List<String> failedUpdates = new ArrayList<String>();
    protected List<String> failedDeletes = new ArrayList<String>();
    protected Lock listLock = new ReentrantLock();

    @JsonProperty(value="successful_updates")
    public List<String> getSuccessfulUpdates() {
        return this.synchronizedCopy(this.successfulUpdates);
    }

    @JsonProperty(value="successful_deletes")
    public List<String> getSuccessfulDeletes() {
        return this.synchronizedCopy(this.successfulDeletes);
    }

    @JsonProperty(value="failed_updates")
    public List<String> getFailedUpdates() {
        return this.synchronizedCopy(this.failedUpdates);
    }

    @JsonProperty(value="failed_deletes")
    public List<String> getFailedDeletes() {
        return this.synchronizedCopy(this.failedDeletes);
    }

    public void addSuccessfulUpdate(String path) {
        this.synchronizedAdd(this.successfulUpdates, path);
    }

    public void addSuccessfulDelete(String path) {
        this.synchronizedAdd(this.successfulDeletes, path);
    }

    public void addFailedUpdate(String path) {
        this.synchronizedAdd(this.failedUpdates, path);
    }

    public void addFailedDelete(String path) {
        this.synchronizedAdd(this.failedDeletes, path);
    }

    @JsonProperty(value="failed_updates_and_deletes")
    public int getFailedUpdatesAndDeletes() {
        this.listLock.lock();
        try {
            int n = this.failedUpdates.size() + this.failedDeletes.size();
            return n;
        }
        finally {
            this.listLock.unlock();
        }
    }

    @JsonProperty(value="successful_updates_and_deletes")
    public int getSuccessfulUpdatesAndDeletes() {
        this.listLock.lock();
        try {
            int n = this.successfulUpdates.size() + this.successfulDeletes.size();
            return n;
        }
        finally {
            this.listLock.unlock();
        }
    }

    @JsonProperty(value="attempted_updates_and_deletes")
    public int getAttemptedUpdatesAndDeletes() {
        this.listLock.lock();
        try {
            int n = this.successfulUpdates.size() + this.successfulDeletes.size() + this.failedUpdates.size() + this.failedDeletes.size();
            return n;
        }
        finally {
            this.listLock.unlock();
        }
    }

    public boolean hasBeenUpdatedOrDeleted(String path) {
        this.listLock.lock();
        try {
            boolean bl = this.successfulUpdates.contains(path) || this.successfulDeletes.contains(path) || this.failedUpdates.contains(path) || this.failedDeletes.contains(path);
            return bl;
        }
        finally {
            this.listLock.unlock();
        }
    }

    protected List<String> synchronizedCopy(List<String> list) {
        this.listLock.lock();
        try {
            ArrayList<String> arrayList = new ArrayList<String>(list);
            return arrayList;
        }
        finally {
            this.listLock.unlock();
        }
    }

    protected void synchronizedAdd(List<String> list, String path) {
        this.listLock.lock();
        try {
            list.add(path);
        }
        finally {
            this.listLock.unlock();
        }
    }
}

