/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.search.batch.utils;

import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.craftercms.core.service.Content;
import org.craftercms.search.batch.UpdateStatus;
import org.craftercms.search.batch.utils.IndexingUtils;
import org.craftercms.search.service.ResourceAwareSearchService;
import org.craftercms.search.service.SearchService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;

public abstract class CrafterSearchIndexingUtils
extends IndexingUtils {
    private static final Logger logger = LoggerFactory.getLogger(CrafterSearchIndexingUtils.class);

    public static void doUpdate(SearchService searchService, String indexId, String siteName, String id, String xml, UpdateStatus updateStatus) {
        searchService.update(indexId, siteName, id, xml, true);
        CrafterSearchIndexingUtils.logUpdate(indexId, siteName, id);
        updateStatus.addSuccessfulUpdate(id);
    }

    public static void doUpdateContent(SearchService searchService, String indexId, String siteName, String id, Content content, UpdateStatus updateStatus) {
        searchService.updateContent(indexId, siteName, id, content);
        CrafterSearchIndexingUtils.logUpdate(indexId, siteName, id);
        updateStatus.addSuccessfulUpdate(id);
    }

    public static void doUpdateContent(SearchService searchService, String indexId, String siteName, String id, Content content, Map<String, List<String>> additionalFields, UpdateStatus updateStatus) {
        searchService.updateContent(indexId, siteName, id, content, additionalFields);
        CrafterSearchIndexingUtils.logUpdate(indexId, siteName, id);
        updateStatus.addSuccessfulUpdate(id);
    }

    public static void doUpdateContent(ResourceAwareSearchService searchService, String indexId, String siteName, String id, Resource resource, UpdateStatus updateStatus) {
        searchService.updateContent(indexId, siteName, id, resource);
        CrafterSearchIndexingUtils.logUpdate(indexId, siteName, id);
        updateStatus.addSuccessfulUpdate(id);
    }

    public static void doUpdateContent(ResourceAwareSearchService searchService, String indexId, String siteName, String id, Resource resource, Map<String, List<String>> additionalFields, UpdateStatus updateStatus) {
        searchService.updateContent(indexId, siteName, id, resource, additionalFields);
        CrafterSearchIndexingUtils.logUpdate(indexId, siteName, id);
        updateStatus.addSuccessfulUpdate(id);
    }

    public static void doDelete(SearchService searchService, String indexId, String siteName, String id, UpdateStatus updateStatus) {
        searchService.delete(indexId, siteName, id);
        CrafterSearchIndexingUtils.logDelete(indexId, siteName, id);
        updateStatus.addSuccessfulDelete(id);
    }

    private static void logUpdate(String indexId, String siteName, String id) {
        logger.debug("File {}:{} added to index {}", new Object[]{siteName, id, StringUtils.isNotEmpty((CharSequence)indexId) ? indexId : "default"});
    }

    private static void logDelete(String indexId, String siteName, String id) {
        logger.debug("File {}:{} deleted to index {}", new Object[]{siteName, id, StringUtils.isNotEmpty((CharSequence)indexId) ? indexId : "default"});
    }
}

