/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.search.metadata.impl;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.craftercms.commons.lang.RegexUtils;
import org.craftercms.core.service.ContentStoreService;
import org.craftercms.core.service.Context;
import org.craftercms.search.metadata.MetadataExtractor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public abstract class AbstractMetadataExtractor
implements MetadataExtractor {
    private static final Logger logger = LoggerFactory.getLogger(AbstractMetadataExtractor.class);
    protected List<String> includePatterns;

    public void setIncludePatterns(List<String> includePatterns) {
        this.includePatterns = includePatterns;
    }

    @Override
    public Map<String, String> extract(String path, ContentStoreService contentStoreService, Context context) {
        logger.debug("Start processing {}", (Object)path);
        Map<String, String> metadata = Collections.emptyMap();
        if ((CollectionUtils.isEmpty(this.includePatterns) || RegexUtils.matchesAny((String)path, this.includePatterns)) && this.isCompatible(path, contentStoreService, context)) {
            logger.debug("Extracting metadata from {}", (Object)path);
            metadata = this.doExtract(path, contentStoreService, context);
        }
        logger.debug("Completed processing {}", (Object)path);
        return metadata;
    }

    protected abstract boolean isCompatible(String var1, ContentStoreService var2, Context var3);

    protected abstract Map<String, String> doExtract(String var1, ContentStoreService var2, Context var3);
}

