/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.search.metadata.impl;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.craftercms.core.service.ContentStoreService;
import org.craftercms.core.service.Context;
import org.craftercms.core.service.Item;
import org.craftercms.search.metadata.impl.AbstractMetadataExtractor;
import org.springframework.beans.factory.annotation.Required;

public class ContentTypeMetadadataExtractor
extends AbstractMetadataExtractor {
    public static final String NAME_PLACEHOLDER = "\\{name\\}";
    public static final String FILE_PLACEHOLDER = "\\{file\\}";
    public static final String DEFAULT_CONFIG_TEMPLATE = "/config/studio/content-types{name}/config.xml";
    public static final String DEFAULT_DEFINITION_TEMPLATE = "/config/studio/content-types{name}/form-definition.xml";
    public static final String DEFAULT_THUMBNAIL_TEMPLATE = "/config/studio/content-types{name}/{file}";
    public static final String DEFAULT_THUMBNAIL_XPATH = "*/image-thumbnail";
    public static final String DEFAULT_PROPERTY_NAME_THUMBNAIL = "thumbnail";
    protected String fieldXpath;
    protected String fieldValue;
    protected String configTemplate = "/config/studio/content-types{name}/config.xml";
    protected String definitionTemplate = "/config/studio/content-types{name}/form-definition.xml";
    protected String thumbnailTemplate = "/config/studio/content-types{name}/{file}";
    protected String thumbnailXpath = "*/image-thumbnail";
    protected String propertyNameThumbnail = "thumbnail";

    @Required
    public void setFieldXpath(String fieldXpath) {
        this.fieldXpath = fieldXpath;
    }

    public void setFieldValue(String fieldValue) {
        this.fieldValue = fieldValue;
    }

    public void setConfigTemplate(String configTemplate) {
        this.configTemplate = configTemplate;
    }

    public void setDefinitionTemplate(String definitionTemplate) {
        this.definitionTemplate = definitionTemplate;
    }

    public void setThumbnailTemplate(String thumbnailTemplate) {
        this.thumbnailTemplate = thumbnailTemplate;
    }

    public void setThumbnailXpath(String thumbnailXpath) {
        this.thumbnailXpath = thumbnailXpath;
    }

    public void setPropertyNameThumbnail(String propertyNameThumbnail) {
        this.propertyNameThumbnail = propertyNameThumbnail;
    }

    @Override
    protected boolean isCompatible(String path, ContentStoreService contentStoreService, Context context) {
        Item item = contentStoreService.getItem(context, path);
        String value = item.queryDescriptorValue(this.fieldXpath);
        return StringUtils.isEmpty((CharSequence)this.fieldValue) ? StringUtils.isNotEmpty((CharSequence)value) : StringUtils.equals((CharSequence)this.fieldValue, (CharSequence)value);
    }

    @Override
    protected Map<String, String> doExtract(String path, ContentStoreService contentStoreService, Context context) {
        HashMap<String, String> metadata = new HashMap<String, String>();
        Item item = contentStoreService.getItem(context, path);
        String contentTypeName = item.queryDescriptorValue(this.fieldXpath);
        this.getConfigMetadata(contentTypeName, contentStoreService, context, metadata);
        this.getDefinitionMetadata(contentTypeName, contentStoreService, context, metadata);
        return metadata;
    }

    protected void getDefinitionMetadata(String contentTypeName, ContentStoreService contentStoreService, Context context, Map<String, String> metadata) {
        String definitionPath = StringUtils.replaceFirst((String)this.definitionTemplate, (String)NAME_PLACEHOLDER, (String)contentTypeName);
        Item definition = contentStoreService.getItem(context, definitionPath);
    }

    protected void getConfigMetadata(String contentTypeName, ContentStoreService contentStoreService, Context context, Map<String, String> metadata) {
        String configPath = StringUtils.replaceFirst((String)this.configTemplate, (String)NAME_PLACEHOLDER, (String)contentTypeName);
        Item config = contentStoreService.getItem(context, configPath);
        String thumbnailFile = config.queryDescriptorValue(this.thumbnailXpath);
        String thumbnailValue = StringUtils.replaceFirst((String)this.thumbnailTemplate, (String)NAME_PLACEHOLDER, (String)contentTypeName);
        thumbnailValue = StringUtils.replaceFirst((String)thumbnailValue, (String)FILE_PLACEHOLDER, (String)thumbnailFile);
        metadata.put(this.propertyNameThumbnail, thumbnailValue);
    }
}

