/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.search.metadata.impl;

import java.util.Collections;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.craftercms.core.service.ContentStoreService;
import org.craftercms.core.service.Context;
import org.craftercms.core.service.Item;
import org.craftercms.search.metadata.impl.AbstractMetadataExtractor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Required;

public class InternalNameMetadataExtractor
extends AbstractMetadataExtractor {
    private static final Logger logger = LoggerFactory.getLogger(InternalNameMetadataExtractor.class);
    public static final String DEFAULT_PROPERTY_NAME = "internalName";
    protected String propertyName = "internalName";
    protected String internalNameFieldXpath;

    public void setPropertyName(String propertyName) {
        this.propertyName = propertyName;
    }

    @Required
    public void setInternalNameFieldXpath(String internalNameFieldXpath) {
        this.internalNameFieldXpath = internalNameFieldXpath;
    }

    @Override
    protected boolean isCompatible(String path, ContentStoreService contentStoreService, Context context) {
        return !contentStoreService.getItem(context, path).isFolder();
    }

    @Override
    protected Map<String, String> doExtract(String path, ContentStoreService contentStoreService, Context context) {
        Item item = contentStoreService.getItem(context, path);
        String internalName = item.queryDescriptorValue(this.internalNameFieldXpath);
        if (StringUtils.isEmpty((CharSequence)internalName)) {
            logger.debug("Internal name not found in descriptor, using filename as fallback");
            internalName = FilenameUtils.getName((String)item.getName());
        }
        return Collections.singletonMap(this.propertyName, internalName);
    }
}

