/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.search.service.impl;

import java.util.Map;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.craftercms.search.service.Query;
import org.craftercms.search.service.impl.QueryParams;

public class SolrQuery
extends QueryParams {
    public static final String FIELDS_TO_RETURN = "fl";
    public static final String HIGHLIGHT_PARAM = "hl";
    public static final String HIGHLIGHT_FIELDS_PARAM = "hl.fl";
    public static final String HIGHLIGHT_SNIPPETS_PARAM = "hl.snippets";
    public static final String HIGHLIGHT_SNIPPET_SIZE_PARAM = "hl.fragsize";
    public static final String QUERY_PARAM = "q";
    public static final String FILTER_QUERY_PARAM = "fq";
    public static final String START_PARAM = "start";
    public static final String ROWS_PARAM = "rows";

    public SolrQuery() {
    }

    public SolrQuery(Map<String, String[]> params) {
        super(params);
    }

    @Override
    public Query setOffset(int offset) {
        return this.setStart(offset);
    }

    @Override
    public int getOffset() {
        return this.getStart();
    }

    @Override
    public Query setNumResults(int numResults) {
        return this.setRows(numResults);
    }

    @Override
    public int getNumResults() {
        return this.getRows();
    }

    @Override
    public SolrQuery setFieldsToReturn(String ... fields) {
        this.addParam(FIELDS_TO_RETURN, fields);
        return this;
    }

    @Override
    public String[] getFieldsToReturn() {
        return this.getParam(FIELDS_TO_RETURN);
    }

    @Override
    public String getQuery() {
        return this.getSingleValue(QUERY_PARAM);
    }

    @Override
    public SolrQuery setQuery(String query) {
        this.setParam(QUERY_PARAM, query);
        return this;
    }

    public boolean isHighlight() {
        return BooleanUtils.toBoolean((String)this.getSingleValue(HIGHLIGHT_PARAM));
    }

    public SolrQuery setHighlight(boolean highlight) {
        this.setParam(HIGHLIGHT_PARAM, Boolean.toString(highlight));
        return this;
    }

    public String[] getHighlightFields() {
        return this.getParam(HIGHLIGHT_FIELDS_PARAM);
    }

    public SolrQuery setHighlightFields(String ... fields) {
        this.setHighlight(true).addParam(HIGHLIGHT_FIELDS_PARAM, fields);
        return this;
    }

    public int getHighlightSnippets() {
        return NumberUtils.toInt((String)this.getSingleValue(HIGHLIGHT_SNIPPETS_PARAM));
    }

    public SolrQuery setHighlightSnippets(int snippets) {
        this.setHighlight(true).setParam(HIGHLIGHT_SNIPPETS_PARAM, Integer.toString(snippets));
        return this;
    }

    public int getHighlightSnippetSize() {
        return NumberUtils.toInt((String)this.getSingleValue(HIGHLIGHT_SNIPPET_SIZE_PARAM));
    }

    public SolrQuery setHighlightSnippetSize(int size) {
        this.setHighlight(true).setParam(HIGHLIGHT_SNIPPET_SIZE_PARAM, Integer.toString(size));
        return this;
    }

    public String[] getFilterQueries() {
        return this.getParam(FILTER_QUERY_PARAM);
    }

    public SolrQuery setFilterQueries(String ... queries) {
        this.addParam(FILTER_QUERY_PARAM, queries);
        return this;
    }

    public SolrQuery addFilterQuery(String query) {
        this.addParam(FILTER_QUERY_PARAM, query);
        return this;
    }

    public int getStart() {
        return NumberUtils.toInt((String)this.getSingleValue(START_PARAM));
    }

    public SolrQuery setStart(int start) {
        this.setParam(START_PARAM, Integer.toString(start));
        return this;
    }

    public int getRows() {
        return NumberUtils.toInt((String)this.getSingleValue(ROWS_PARAM));
    }

    public SolrQuery setRows(int rows) {
        this.setParam(ROWS_PARAM, Integer.toString(rows));
        return this;
    }
}

