/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.social.controllers.rest.v3;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileUploadBase;
import org.apache.commons.io.FileExistsException;
import org.apache.commons.lang3.StringUtils;
import org.craftercms.commons.exceptions.InvalidManagementTokenException;
import org.craftercms.commons.file.FileUtils;
import org.craftercms.commons.security.exception.ActionDeniedException;
import org.craftercms.security.exception.AuthenticationRequiredException;
import org.craftercms.social.controllers.rest.v3.comments.exceptions.UGCNotFound;
import org.craftercms.social.exceptions.IllegalSocialQueryException;
import org.craftercms.social.exceptions.IllegalUgcException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpStatus;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.multipart.MaxUploadSizeExceededException;

@ControllerAdvice
public class GlobalDefaultExceptionHandler {
    private Logger log = LoggerFactory.getLogger(GlobalDefaultExceptionHandler.class);
    @Value(value="${studio.social.web.system.throwStacktrace}")
    private boolean throwStacktrace;
    private ObjectWriter converter = new ObjectMapper().writer();

    @ExceptionHandler(value={Throwable.class})
    public void defaultErrorHandler(HttpServletRequest req, HttpServletResponse resp, Exception e) throws Exception {
        this.log.error("Request: " + req.getRequestURL() + " raised and error {}", (Throwable)e);
        this.serializeError(e, resp, HttpStatus.INTERNAL_SERVER_ERROR, req);
    }

    @ExceptionHandler(value={ActionDeniedException.class})
    public void ActionDeniedHandler(HttpServletRequest req, HttpServletResponse resp, Exception e) throws Exception {
        this.log.error("Request: " + req.getRequestURL() + " raised and error {}", (Throwable)e);
        this.serializeError(e, resp, HttpStatus.FORBIDDEN, req);
    }

    @ExceptionHandler(value={UGCNotFound.class})
    public void ugcNotFound(HttpServletRequest req, HttpServletResponse resp, Exception e) throws IOException {
        this.log.debug("Request {} for a non existent UGC (or does not belong to context)", (Object)req.getRequestURL());
        this.serializeError(e, resp, HttpStatus.NOT_FOUND, req);
    }

    @ExceptionHandler(value={MissingServletRequestParameterException.class, IllegalSocialQueryException.class, IllegalArgumentException.class, FileExistsException.class, IllegalUgcException.class})
    public void missingParameterHandler(HttpServletRequest req, HttpServletResponse resp, Exception e) throws Exception {
        this.serializeError(e, resp, HttpStatus.BAD_REQUEST, req);
    }

    @ExceptionHandler(value={HttpRequestMethodNotSupportedException.class})
    public void requestMethodNotSupportedException(HttpServletRequest req, HttpServletResponse resp, Exception e) throws Exception {
        this.serializeError(e, resp, HttpStatus.NOT_ACCEPTABLE, req);
    }

    @ExceptionHandler(value={AuthenticationRequiredException.class})
    public void authenticationRequiredExceptionHandler(HttpServletRequest req, HttpServletResponse resp, Exception e) throws Exception {
        this.log.error("Request: " + req.getRequestURL() + " raised and error {}", (Throwable)e);
        this.serializeError(e, resp, HttpStatus.UNAUTHORIZED, req);
    }

    @ExceptionHandler(value={InvalidManagementTokenException.class})
    public void invalidManagementTokenExceptionHandler(HttpServletRequest request, HttpServletResponse response, InvalidManagementTokenException e) throws IOException {
        this.log.error("Request: {} raised and error", (Object)request.getRequestURL(), (Object)e);
        this.serializeError((Exception)e, response, HttpStatus.UNAUTHORIZED, request);
    }

    @ExceptionHandler(value={MaxUploadSizeExceededException.class})
    public void sizeLimitExceededException(HttpServletRequest req, HttpServletResponse response, Exception ex) throws Exception {
        this.log.error("Request: " + req.getRequestURL() + " raised and error {}", (Object)ex.toString());
        FileUploadBase.SizeLimitExceededException realEx = (FileUploadBase.SizeLimitExceededException)ex.getCause();
        String maxSize = FileUtils.readableFileSize((long)realEx.getPermittedSize());
        String fileSize = FileUtils.readableFileSize((long)realEx.getActualSize());
        HashMap<String, String> error = new HashMap<String, String>();
        error.put("message", String.format("Unable to upload file due size limit is %s and upload size is %s", maxSize, fileSize));
        error.put("maxSize", maxSize);
        error.put("fileSize", fileSize);
        response.setContentType("application/json");
        response.setStatus(HttpStatus.BAD_REQUEST.value());
        this.converter.writeValue((OutputStream)response.getOutputStream(), error);
    }

    private void serializeError(Exception ex, HttpServletResponse response, HttpStatus status, HttpServletRequest req) throws IOException {
        this.log.error("Request: " + req.getRequestURL() + " raised and error {}", (Object)ex.toString());
        this.log.error("Error processing request", (Throwable)ex);
        HashMap<String, String> error = new HashMap<String, String>();
        if (StringUtils.isBlank((CharSequence)ex.getMessage())) {
            error.put("error", "Unknown Error");
        } else {
            error.put("error", ex.getMessage());
            error.put("message", ex.getMessage());
        }
        if (this.throwStacktrace) {
            error.put("stacktrace", this.getStackTrace((Throwable)ex));
        }
        response.setContentType("application/json");
        response.setStatus(status.value());
        this.converter.writeValue((OutputStream)response.getOutputStream(), error);
    }

    public String getStackTrace(Throwable throwable) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter((Writer)sw, true);
        throwable.printStackTrace(pw);
        return sw.getBuffer().toString();
    }
}

