/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.social.controllers.rest.v3.comments;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.activation.MimetypesFileTypeMap;
import org.bson.types.ObjectId;
import org.craftercms.profile.api.Profile;
import org.craftercms.security.exception.AuthenticationRequiredException;
import org.craftercms.social.domain.social.SocialUgc;
import org.craftercms.social.security.SocialSecurityUtils;
import org.craftercms.social.services.notification.NotificationService;
import org.craftercms.social.services.social.SocialServices;
import org.craftercms.social.services.ugc.UGCService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@RequestMapping(value={"/api/3/comments"})
public class AbstractCommentsController<T extends SocialUgc> {
    @Autowired
    protected SocialServices socialServices;
    @Autowired
    protected NotificationService notificationService;
    @Autowired
    protected UGCService ugcService;

    protected Map<String, Object> parseAttributes(String attributes) throws MissingServletRequestParameterException {
        ObjectMapper mapper = new ObjectMapper();
        JsonFactory factory = mapper.getFactory();
        try {
            JsonParser jp = factory.createParser(attributes);
            return (Map)mapper.readValue(jp, HashMap.class);
        }
        catch (IOException e) {
            throw new MissingServletRequestParameterException("attributes", "Json");
        }
    }

    protected String context() {
        return SocialSecurityUtils.getContext();
    }

    protected String userId() {
        ObjectId id = this.getCurrentProfile().getId();
        if (id == null) {
            throw new AuthenticationRequiredException("Missing or expired auth token");
        }
        return id.toString();
    }

    protected Profile getCurrentProfile() {
        return SocialSecurityUtils.getCurrentProfile();
    }

    protected String getContentType(String filename) {
        return new MimetypesFileTypeMap().getContentType(filename);
    }
}

