/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.social.controllers.rest.v3.comments;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.activation.MimetypesFileTypeMap;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.craftercms.commons.mongo.FileInfo;
import org.craftercms.social.controllers.rest.v3.comments.AbstractCommentsController;
import org.craftercms.social.controllers.rest.v3.comments.exceptions.UGCNotFound;
import org.craftercms.social.domain.social.SocialUgc;
import org.craftercms.social.exceptions.SocialException;
import org.craftercms.social.exceptions.UGCException;
import org.hibernate.validator.constraints.NotBlank;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.Resource;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

@Controller
public class AttachmentsController<T extends SocialUgc>
extends AbstractCommentsController {
    private Logger log = LoggerFactory.getLogger(AttachmentsController.class);
    @Value(value="${studio.social.web.mimeFile}")
    protected Resource mimeFile;

    @RequestMapping(value={"/{id}/attachments"}, method={RequestMethod.POST})
    @ResponseBody
    public FileInfo addAttachment(@NotBlank @PathVariable(value="id") String id, @RequestParam MultipartFile attachment) throws SocialException, IOException {
        this.log.debug("Adding Attachment for UGC {} ", (Object)id);
        FileInfo fileInfo = this.ugcService.addAttachment(id, this.context(), attachment.getInputStream(), attachment.getOriginalFilename(), new MimetypesFileTypeMap(this.mimeFile.getInputStream()).getContentType(attachment.getOriginalFilename().toLowerCase()));
        if (fileInfo == null) {
            throw new UGCException("Given File contains a virus");
        }
        return fileInfo;
    }

    @RequestMapping(value={"/{id}/attachments/{attachmentId}"}, method={RequestMethod.DELETE})
    @ResponseBody
    public boolean removeAttachment(@NotBlank @PathVariable(value="id") String id, @NotBlank @PathVariable(value="attachmentId") String attachmentId) throws SocialException, IOException {
        this.log.debug("Removing Attachment for UGC {} with Id {}", (Object)id, (Object)attachmentId);
        this.ugcService.removeAttachment(id, this.context(), attachmentId);
        return true;
    }

    @RequestMapping(value={"/{id}/attachments/{attachmentId}/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public boolean removeAttachmentPost(@NotBlank @PathVariable(value="id") String id, @NotBlank @PathVariable(value="attachmentId") String attachmentId) throws SocialException, IOException {
        return this.removeAttachment(id, attachmentId);
    }

    @RequestMapping(value={"/{id}/attachments/{attachmentId}/update"}, method={RequestMethod.POST})
    @ResponseBody
    public boolean updateAttachmentPost(@NotBlank @PathVariable(value="id") String id, @NotBlank @PathVariable(value="attachmentId") String attachmentId, @RequestParam MultipartFile file) throws SocialException, IOException {
        this.log.debug("Removing Attachment for UGC {} with Id {}", (Object)id, (Object)attachmentId);
        this.ugcService.updateAttachment(id, this.context(), attachmentId, file.getInputStream());
        return true;
    }

    @RequestMapping(value={"/{id}/attachments"}, method={RequestMethod.GET})
    @ResponseBody
    public Iterable<FileInfo> listAttachments(@NotBlank @PathVariable(value="id") String id) throws SocialException, UGCNotFound {
        this.log.debug("Listing all Attachments for UGC {}", (Object)id);
        SocialUgc ugc = (SocialUgc)this.ugcService.read(id, this.context());
        if (ugc == null) {
            throw new UGCNotFound("Ugc with Id " + id + " does not Exist");
        }
        return ugc.getAttachments();
    }

    @RequestMapping(value={"/{id}/attachments/{attachmentId}"}, method={RequestMethod.GET})
    @ResponseBody
    public void readAttachment(@NotBlank @PathVariable(value="id") String id, @NotBlank @PathVariable(value="attachmentId") String attachmentId, HttpServletResponse response) throws SocialException, IOException {
        this.log.debug("Reading Attachment for UGC {} with Id {}", (Object)id, (Object)attachmentId);
        FileInfo fileInfo = this.ugcService.readAttachment(id, this.context(), attachmentId);
        response.setStatus(200);
        response.setContentType(fileInfo.getContentType());
        String realName = fileInfo.getStoreName().substring(fileInfo.getStoreName().lastIndexOf(File.separator));
        response.setHeader("Content-Disposition", "filename=\"" + realName + "\"");
        response.setContentLength((int)fileInfo.getFileSizeBytes());
        IOUtils.copy((InputStream)fileInfo.getInputStream(), (OutputStream)response.getOutputStream());
        response.getOutputStream().flush();
    }
}

