/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.social.controllers.rest.v3.comments;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.craftercms.commons.collections.IterableUtils;
import org.craftercms.profile.api.Profile;
import org.craftercms.social.controllers.rest.v3.comments.AbstractCommentsController;
import org.craftercms.social.controllers.rest.v3.comments.SocialSortOrder;
import org.craftercms.social.controllers.rest.v3.comments.ThreadsController;
import org.craftercms.social.controllers.rest.v3.comments.exceptions.UGCNotFound;
import org.craftercms.social.domain.social.Flag;
import org.craftercms.social.domain.social.ModerationStatus;
import org.craftercms.social.domain.social.SocialUgc;
import org.craftercms.social.exceptions.IllegalUgcException;
import org.craftercms.social.exceptions.SocialException;
import org.craftercms.social.exceptions.UGCException;
import org.craftercms.social.security.SocialSecurityUtils;
import org.hibernate.validator.constraints.NotBlank;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

@Controller
public class CommentsController<T extends SocialUgc>
extends AbstractCommentsController {
    private Logger log = LoggerFactory.getLogger(CommentsController.class);

    @RequestMapping(method={RequestMethod.POST})
    @ResponseBody
    public T create(@RequestParam String body, @RequestParam String thread, @RequestParam(required=false, defaultValue="") String parent, @RequestParam(required=false, defaultValue="false", value="anonymous") boolean anonymous, @RequestParam(required=false, defaultValue="", value="subject") String subject, @RequestParam(required=false, defaultValue="{}") String attributes, MultipartFile attachment) throws SocialException, MissingServletRequestParameterException, IOException {
        Map attributesMap = null;
        if (!StringUtils.isBlank((CharSequence)attributes)) {
            attributesMap = this.parseAttributes(attributes);
        }
        SocialUgc newUgc = (SocialUgc)this.ugcService.create(this.context(), parent, thread, body, subject, attributesMap, this.checkAnonymous(anonymous));
        if (attachment != null) {
            this.ugcService.addAttachment(newUgc.getId().toString(), this.context(), attachment.getInputStream(), attachment.getOriginalFilename(), this.getContentType(attachment.getOriginalFilename()));
        }
        return (T)newUgc;
    }

    @RequestMapping(value={"{id}"}, method={RequestMethod.PUT})
    @ResponseBody
    public T update(@PathVariable(value="id") String id, @RequestParam String body, @RequestParam(required=false, defaultValue="{}") String attributes) throws SocialException, MissingServletRequestParameterException, UGCNotFound {
        Map attributesMap = null;
        if (!StringUtils.isBlank((CharSequence)attributes)) {
            attributesMap = this.parseAttributes(attributes);
        }
        return (T)((SocialUgc)this.ugcService.update(id, body, "", this.context(), attributesMap));
    }

    @RequestMapping(value={"{id}/update"}, method={RequestMethod.POST})
    @ResponseBody
    public T updatePost(@PathVariable(value="id") String id, @RequestParam String body, @RequestParam(required=false, defaultValue="{}") String attributes) throws SocialException, MissingServletRequestParameterException, UGCNotFound {
        return (T)this.update(id, body, attributes);
    }

    @RequestMapping(value={"{id}"}, method={RequestMethod.DELETE})
    @ResponseBody
    public boolean delete(@PathVariable(value="id") String id) throws SocialException {
        this.ugcService.deleteUgc(id, this.context());
        return true;
    }

    @RequestMapping(value={"{id}/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public boolean deletePost(@PathVariable(value="id") String id) throws SocialException {
        return this.delete(id);
    }

    @RequestMapping(value={"{id}"}, method={RequestMethod.GET})
    @ResponseBody
    public T read(@PathVariable(value="id") String id) throws SocialException {
        return (T)((SocialUgc)this.ugcService.read(id, this.context()));
    }

    @RequestMapping(value={"/search"}, method={RequestMethod.POST})
    @ResponseBody
    public Iterable<T> read(@RequestParam String search, @RequestParam String sortBy, @RequestParam int start, @RequestParam int limit) throws SocialException {
        return this.ugcService.search(this.context(), search, sortBy, start, limit);
    }

    @RequestMapping(value={"{id}/attributes"}, method={RequestMethod.POST, RequestMethod.PUT}, consumes={"application/x-www-form-urlencoded"})
    @ResponseBody
    public boolean addAttributes(@NotBlank @PathVariable(value="id") String id, @RequestParam Map<String, Object> attributes) throws SocialException, UGCNotFound {
        this.log.debug("Request for deleting form  UGC {} attributes {}", (Object)id, attributes);
        attributes.remove("context");
        this.ugcService.setAttributes(id, this.context(), attributes);
        return true;
    }

    @RequestMapping(value={"{id}/attributes"}, method={RequestMethod.DELETE})
    @ResponseBody
    public boolean removeAttributes(@PathVariable(value="id") String id, @RequestParam String attributes) throws SocialException {
        this.log.debug("Request for deleting form  UGC {} attributes {}", (Object)id, (Object)attributes);
        this.ugcService.deleteAttribute(id, attributes.split(","), this.context());
        return true;
    }

    @RequestMapping(value={"{id}/attributes/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public boolean removeAttributesPost(@PathVariable(value="id") String id, @RequestParam String attributes) throws SocialException {
        return this.removeAttributes(id, attributes);
    }

    @RequestMapping(value={"{id}/flags"}, method={RequestMethod.POST})
    @ResponseBody
    public T flagUgc(@PathVariable(value="id") String id, @RequestParam String reason) throws SocialException {
        return (T)this.socialServices.flag(id, this.context(), reason, this.userId());
    }

    @RequestMapping(value={"{id}/flags"}, method={RequestMethod.GET})
    @ResponseBody
    public Iterable<Flag> flagUgc(@PathVariable(value="id") String id) throws SocialException {
        SocialUgc ugc = (SocialUgc)this.ugcService.read(id, this.context());
        if (ugc == null) {
            throw new IllegalUgcException("Given UGC does not exist for context");
        }
        return ugc.getFlags();
    }

    @RequestMapping(value={"{id}/flags/{flagId}"}, method={RequestMethod.POST, RequestMethod.DELETE})
    @ResponseBody
    public boolean unflagUgc(@PathVariable(value="id") String id, @PathVariable(value="flagId") String flagId) throws SocialException {
        return this.socialServices.unFlag(id, flagId, this.userId(), this.context());
    }

    @RequestMapping(value={"{id}/moderate"}, method={RequestMethod.POST, RequestMethod.PUT})
    @ResponseBody
    public T moderate(@PathVariable String id, @RequestParam ModerationStatus status) throws SocialException {
        return (T)this.socialServices.moderate(id, status, this.userId(), this.context());
    }

    @RequestMapping(value={"moderation/{status}"}, method={RequestMethod.GET})
    @ResponseBody
    public Iterable<T> byStatus(@PathVariable(value="status") ModerationStatus status, @RequestParam(defaultValue="", required=false) String thread, @RequestParam(required=false, defaultValue="0") int pageNumber, @RequestParam(required=false, defaultValue="666") int pageSize, @RequestParam(required=false) List<String> sortBy, @RequestParam(required=false) List<SocialSortOrder> sortOrder) throws UGCException {
        int start = 0;
        if (pageNumber > 0 && pageSize > 0) {
            start = ThreadsController.getStart((int)pageNumber, (int)pageSize);
        }
        return IterableUtils.toList((Iterable)this.socialServices.findByModerationStatus(status, thread, this.context(), start, pageSize, ThreadsController.getSortOrder(sortBy, sortOrder)));
    }

    @RequestMapping(value={"flagged"}, method={RequestMethod.GET})
    @ResponseBody
    public Iterable<T> flagged(@RequestParam(required=false, defaultValue="0") int pageNumber, @RequestParam(required=false, defaultValue="666") int pageSize, @RequestParam(required=false) List<String> sortBy, @RequestParam(required=false) List<SocialSortOrder> sortOrder) throws UGCException {
        int start = 0;
        if (pageNumber > 0 && pageSize > 0) {
            start = ThreadsController.getStart((int)pageNumber, (int)pageSize);
        }
        return IterableUtils.toList((Iterable)this.socialServices.findAllFlaggedUgs(this.context(), start, pageSize, ThreadsController.getSortOrder(sortBy, sortOrder)));
    }

    @RequestMapping(value={"flagged/count"}, method={RequestMethod.GET})
    @ResponseBody
    public long flaggedCount(@RequestParam(required=false, defaultValue="0") int pageNumber, @RequestParam(required=false, defaultValue="666") int pageSize, @RequestParam(required=false) List<String> sortBy, @RequestParam(required=false) List<SocialSortOrder> sortOrder) throws UGCException {
        int start = 0;
        if (pageNumber > 0 && pageSize > 0) {
            start = ThreadsController.getStart((int)pageNumber, (int)pageSize);
        }
        return this.socialServices.countAllFlaggedUgs(this.context(), start, pageSize, ThreadsController.getSortOrder(sortBy, sortOrder));
    }

    @RequestMapping(value={"moderation/{status}/count"}, method={RequestMethod.GET})
    @ResponseBody
    public long byStatusCount(@PathVariable(value="status") ModerationStatus status, @RequestParam(defaultValue="", required=false) String thread) throws UGCException {
        return this.socialServices.countByModerationStatus(status, thread, this.context());
    }

    protected boolean checkAnonymous(boolean anonymous) {
        Profile profile = SocialSecurityUtils.getCurrentProfile();
        Object isAlwaysAnonymous = profile.getAttribute("isAlwaysAnonymous");
        if (isAlwaysAnonymous == null) {
            return anonymous;
        }
        return (Boolean)isAlwaysAnonymous;
    }
}

