/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.social.controllers.rest.v3.comments;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.bson.types.ObjectId;
import org.craftercms.profile.api.Profile;
import org.craftercms.profile.api.exceptions.ProfileException;
import org.craftercms.profile.api.services.ProfileAttachment;
import org.craftercms.profile.api.services.ProfileService;
import org.craftercms.social.exceptions.SocialException;
import org.craftercms.social.security.SocialSecurityUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Controller
@RequestMapping(value={"/api/3/profile"})
public class ProfileHelperController {
    public static final String AVATAR = "avatar";
    @Autowired
    protected ProfileService profileService;

    @RequestMapping(value={"/avatar/{profileId}"}, method={RequestMethod.POST})
    @ResponseBody
    public Profile getProfileAvatar(MultipartHttpServletRequest request, HttpServletResponse response, @PathVariable(value="profileId") String profileId) throws IOException, ProfileException {
        Profile profile = SocialSecurityUtils.getCurrentProfile();
        if (profile != null && !profile.getUsername().equalsIgnoreCase("ANONYMOUS")) {
            Iterator files = request.getFileNames();
            String fileName = null;
            if (files.hasNext()) {
                fileName = (String)files.next();
            }
            if (!StringUtils.isBlank(fileName)) {
                MultipartFile avatar = request.getFile(fileName);
                this.profileService.addProfileAttachment(profile.getId().toString(), "avatar." + FilenameUtils.getExtension((String)avatar.getOriginalFilename()).toLowerCase(), avatar.getInputStream());
            }
            return profile;
        }
        response.setStatus(400);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/avatar/{profileId}"}, method={RequestMethod.GET})
    public void getProfileAvatar(HttpServletResponse response, @PathVariable(value="profileId") String profileId, HttpServletRequest request) throws IOException, SocialException {
        boolean imageFound = false;
        try (InputStream input = null;){
            try {
                ProfileAttachment information;
                if (ObjectId.isValid((String)profileId) && (information = this.profileService.getProfileAttachmentInformation(profileId, AVATAR)) != null) {
                    response.setContentType(information.getContentType());
                    response.setContentLength((int)information.getFileSizeBytes());
                    response.setHeader("Cache-Control", "max-age=3600");
                    response.setStatus(200);
                    input = this.profileService.getProfileAttachment(AVATAR, profileId);
                    IOUtils.copy((InputStream)input, (OutputStream)response.getOutputStream());
                    imageFound = true;
                }
            }
            catch (ProfileException ex) {
                imageFound = false;
            }
            if (!imageFound) {
                response.sendRedirect(request.getContextPath() + "/resources/silhouette.png");
            }
        }
    }
}

