/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.social.controllers.rest.v3.comments;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.keyvalue.DefaultKeyValue;
import org.craftercms.profile.api.Profile;
import org.craftercms.social.controllers.rest.v3.comments.SocialSortOrder;
import org.craftercms.social.controllers.rest.v3.comments.Thread;
import org.craftercms.social.controllers.rest.v3.comments.exceptions.UGCNotFound;
import org.craftercms.social.exceptions.SocialException;
import org.craftercms.social.exceptions.UGCException;
import org.craftercms.social.security.SocialSecurityUtils;
import org.craftercms.social.services.notification.NotificationService;
import org.craftercms.social.services.ugc.UGCService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

/*
 * Exception performing whole class analysis ignored.
 */
@Controller
@RequestMapping(value={"/api/3/threads"})
public class ThreadsController {
    public static final String MAX_INT = "666";
    @Autowired
    private UGCService ugcService;
    @Autowired
    private NotificationService notificationService;

    @RequestMapping(value={"{id}/comments"}, method={RequestMethod.GET})
    @ResponseBody
    public Thread thread(@PathVariable String id, @RequestParam(required=false, defaultValue="666") int recursive, @RequestParam(required=false, defaultValue="0") int pageNumber, @RequestParam(required=false, defaultValue="666") int pageSize, @RequestParam(required=false, defaultValue="666") int childrenCount, @RequestParam(required=false) List<String> sortBy, @RequestParam(required=false) List<SocialSortOrder> sortOrder) throws SocialException {
        int start = 0;
        if (pageNumber > 0 && pageSize > 0) {
            start = ThreadsController.getStart((int)pageNumber, (int)pageSize);
        }
        Thread thread = new Thread();
        int upToLevel = recursive < 0 ? Integer.MAX_VALUE : recursive;
        thread.setComments(this.ugcService.read(id, SocialSecurityUtils.getContext(), start, pageSize, ThreadsController.getSortOrder(sortBy, sortOrder), upToLevel, childrenCount));
        if (SocialSecurityUtils.getCurrentProfile().getUsername().equalsIgnoreCase("ANONYMOUS")) {
            thread.setWatched(false);
        } else {
            thread.setWatched(this.notificationService.isBeenWatch(SocialSecurityUtils.getContext() + "/" + id, SocialSecurityUtils.getCurrentProfile().getId().toString()));
        }
        thread.setPageNumber(pageNumber);
        thread.setPageSize(pageSize);
        thread.setTotal(this.ugcService.count(id, SocialSecurityUtils.getContext()));
        return thread;
    }

    @RequestMapping(value={"{id}/comments/{commentId}/children"}, method={RequestMethod.GET})
    @ResponseBody
    public Thread comments(@PathVariable String id, @PathVariable String commentId, @RequestParam(required=false, defaultValue="666") int recursive, @RequestParam(required=false, defaultValue="0") int pageNumber, @RequestParam(required=false, defaultValue="666") int pageSize, @RequestParam(required=false, defaultValue="666") int childrenCount, @RequestParam(required=false) List<String> sortBy, @RequestParam(required=false) List<SocialSortOrder> sortOrder) throws SocialException {
        int start = 0;
        if (pageNumber > 0 && pageSize > 0) {
            start = ThreadsController.getStart((int)pageNumber, (int)pageSize);
        }
        Thread thread = new Thread();
        int upToLevel = recursive < 0 ? Integer.MAX_VALUE : recursive;
        try {
            thread.setComments(this.ugcService.readChildren(commentId, id, SocialSecurityUtils.getContext(), start, pageSize, ThreadsController.getSortOrder(sortBy, sortOrder), upToLevel, childrenCount));
        }
        catch (UGCNotFound ugcNotFound) {
            ugcNotFound.printStackTrace();
        }
        thread.setWatched(this.notificationService.isBeenWatch(SocialSecurityUtils.getContext() + "/" + id, SocialSecurityUtils.getCurrentProfile().getId().toString()));
        thread.setPageNumber(pageNumber);
        thread.setPageSize(pageSize);
        thread.setTotal(this.ugcService.countChildren(commentId, SocialSecurityUtils.getContext()));
        thread.setTotal(this.ugcService.count(id, SocialSecurityUtils.getContext()));
        return thread;
    }

    @RequestMapping(value={"{id}/subscribe"}, method={RequestMethod.POST})
    @ResponseBody
    public boolean subscribe(@PathVariable String id, @RequestParam(required=false, defaultValue="") String frequency, @RequestParam String context) throws UGCException {
        Profile p = SocialSecurityUtils.getCurrentProfile();
        if (!p.getUsername().equals("ANONYMOUS")) {
            this.notificationService.subscribeUser(p, context + "/" + id, frequency);
            return true;
        }
        return false;
    }

    @RequestMapping(value={"{id}/subscribe"}, method={RequestMethod.PUT})
    @ResponseBody
    public boolean changeSubscribe(@PathVariable String id, @RequestParam(required=false, defaultValue="") String frequency, @RequestParam String context) throws UGCException {
        Profile p = SocialSecurityUtils.getCurrentProfile();
        if (!p.getUsername().equals("ANONYMOUS")) {
            this.notificationService.changeSubscription(p, context + "/" + id, frequency);
            return true;
        }
        return false;
    }

    @RequestMapping(value={"{id}/subscribe/update"}, method={RequestMethod.POST})
    @ResponseBody
    public boolean changeSubscribePost(@PathVariable String id, @RequestParam(required=false, defaultValue="") String frequency, @RequestParam String context) throws UGCException {
        return this.changeSubscribe(id, frequency, context);
    }

    @RequestMapping(value={"/subscriptions"}, method={RequestMethod.GET})
    @ResponseBody
    public List<Map> subscriptions(@RequestParam String context) throws SocialException {
        return this.notificationService.getUserSubscriptions();
    }

    @RequestMapping(value={"{id}/unsubscribe"}, method={RequestMethod.POST, RequestMethod.DELETE})
    @ResponseBody
    public boolean unSubscribe(@PathVariable String id, @RequestParam String context) throws UGCException {
        Profile p = SocialSecurityUtils.getCurrentProfile();
        if (!p.getUsername().equals("ANONYMOUS")) {
            this.notificationService.unSubscribeUser(p.getId().toString(), context + "/" + id);
            return true;
        }
        return false;
    }

    public static List<DefaultKeyValue<String, Boolean>> getSortOrder(List<String> sortFields, List<SocialSortOrder> sortOrder) {
        if (CollectionUtils.isEmpty(sortFields)) {
            return Arrays.asList(new DefaultKeyValue((Object)"createdBy", (Object)SocialSortOrder.DESC.value()));
        }
        ArrayList<DefaultKeyValue<String, Boolean>> toReturn = new ArrayList<DefaultKeyValue<String, Boolean>>();
        for (int i = 0; i < sortFields.size(); ++i) {
            DefaultKeyValue mapSort = CollectionUtils.isEmpty(sortOrder) || i >= sortOrder.size() ? new DefaultKeyValue((Object)sortFields.get(i), (Object)SocialSortOrder.DESC.value()) : new DefaultKeyValue((Object)sortFields.get(i), (Object)sortOrder.get(i).value());
            toReturn.add((DefaultKeyValue<String, Boolean>)mapSort);
        }
        return toReturn;
    }

    public static int getStart(int page, int pageSize) {
        if (page <= 0) {
            return 0;
        }
        return (page - 1) * pageSize;
    }
}

