/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.social.controllers.rest.v3.comments.ext;

import freemarker.cache.TemplateLoader;
import freemarker.core.Environment;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.security.auth.Subject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.craftercms.profile.api.Profile;
import org.craftercms.profile.api.VerificationToken;
import org.craftercms.profile.api.exceptions.ProfileException;
import org.craftercms.profile.api.services.ProfileService;
import org.craftercms.social.domain.UGC;
import org.craftercms.social.exceptions.SocialException;
import org.craftercms.social.services.notification.NotificationService;
import org.craftercms.social.services.social.SocialServices;
import org.craftercms.social.services.ugc.UGCService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/api/3/comments/extension"})
public class CommentsExtensionController
implements InitializingBean {
    private static final String APPROVER_RESULT_TEMPLATE_NAME = "APPROVER_RESULT_TEMPLATE";
    @Autowired
    protected SocialServices socialServices;
    @Autowired
    protected NotificationService notificationService;
    @Autowired
    protected UGCService ugcService;
    @Autowired
    @Qualifier(value="social.util.email.notificationFreemarkerLoader")
    protected TemplateLoader templateLoader;
    @Autowired
    @Qualifier(value="social.notification.emailModelExt")
    private Map<String, Object> extMap;
    @Autowired
    private ProfileService profileService;
    @Value(value="${studio.social.system.defaultLocale}")
    private String systemDefaultLocale;
    private Configuration cfg;
    private Logger logger = LoggerFactory.getLogger(CommentsExtensionController.class);

    @RequestMapping(value={"approve/{id}/{tokenId}"}, method={RequestMethod.GET})
    @ResponseBody
    public void approveComment(@PathVariable(value="id") String ugcId, @PathVariable(value="tokenId") String profileTokenId, HttpServletResponse response, HttpServletRequest request, @RequestParam(required=true, value="context") String context) throws IOException, TemplateException, SocialException, ProfileException {
        HashMap<String, Object> dataModel = new HashMap<String, Object>(this.extMap);
        dataModel.put("ugc", ugcId);
        dataModel.put("token", profileTokenId);
        dataModel.put("request", request);
        Profile profile = null;
        PrintWriter writer = response.getWriter();
        try {
            VerificationToken token = this.profileService.getVerificationToken(profileTokenId);
            if (token != null) {
                profile = this.profileService.getProfile(token.getProfileId(), new String[0]);
            }
        }
        catch (ProfileException ex) {
            this.logger.error("Error getting the profile with given token", (Throwable)ex);
        }
        UGC ugc = this.ugcService.read(ugcId, context);
        if (ugc == null) {
            response.getWriter().println("UGC not found");
            response.setStatus(404);
            return;
        }
        if (profile != null) {
            dataModel.put("expireToken", false);
            dataModel.put("profile", profile);
            dataModel.putAll(this.socialServices.approveComment(ugc, profile));
            try {
                ugc.setUser(this.profileService.getProfile(ugc.getCreatedBy(), new String[0]));
            }
            catch (ProfileException ex) {
                Profile dummy = new Profile();
                dummy.setAttribute("displayName", (Object)"User Not found");
                ugc.setUser(dummy);
            }
        } else {
            dataModel.put("expireToken", true);
        }
        dataModel.put("ugc", ugc);
        Template template = this.cfg.getTemplate(context + "/APPROVER_RESULT_TEMPLATE", this.getProfileLocale(profile));
        Environment env = template.createProcessingEnvironment(dataModel, (Writer)writer);
        env.process();
        writer.flush();
        response.setContentType("text/html");
        response.setStatus(200);
    }

    public void afterPropertiesSet() {
        this.cfg = new Configuration(Configuration.VERSION_2_3_21);
        this.cfg.setDefaultEncoding("UTF-8");
        this.cfg.setOutputEncoding("UTF-8");
        this.cfg.setTemplateLoader(this.templateLoader);
    }

    private Locale getProfileLocale(Profile profile) {
        if (profile == null) {
            return new Locale(this.systemDefaultLocale);
        }
        Subject notificationLocale = (Subject)profile.getAttribute("notificationLocale");
        if (notificationLocale == null) {
            return new Locale(this.systemDefaultLocale);
        }
        return new Locale(notificationLocale.toString());
    }
}

