/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.social.controllers.rest.v3.system;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.craftercms.profile.api.Profile;
import org.craftercms.security.exception.AuthenticationRequiredException;
import org.craftercms.social.domain.social.system.SocialContext;
import org.craftercms.social.exceptions.SocialException;
import org.craftercms.social.security.SocialSecurityUtils;
import org.craftercms.social.services.system.ContextPreferencesService;
import org.craftercms.social.services.system.SocialContextService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@RequestMapping(value={"/api/3/system/context"})
@Controller
public class SocialContextController {
    @Autowired
    private SocialContextService socialContextService;
    @Autowired
    private ContextPreferencesService contextPreferencesService;

    @RequestMapping(value={"/all"}, method={RequestMethod.GET})
    @ResponseBody
    public Iterable<SocialContext> getAllContexts() throws SocialException {
        return this.socialContextService.getAllContexts();
    }

    @RequestMapping(method={RequestMethod.POST})
    @ResponseBody
    public SocialContext create(@RequestParam String contextName) throws SocialException {
        return this.socialContextService.createNewContext(contextName);
    }

    @RequestMapping(value={"/{id}/{profileId}"}, method={RequestMethod.POST})
    @ResponseBody
    public Profile addProfileToContext(@PathVariable(value="id") String contextId, @PathVariable(value="profileId") String profileId, @RequestParam String roles) throws SocialException {
        if (roles.toUpperCase().contains("SOCIAL_SUPERADMIN")) {
            throw new IllegalArgumentException("SOCIAL_SUPERADMIN is not a valid role");
        }
        return this.socialContextService.addProfileToContext(profileId, contextId, StringUtils.split((String)roles, (char)','));
    }

    @RequestMapping(value={"/{id}/{profileId}/delete"}, method={RequestMethod.DELETE, RequestMethod.POST})
    @ResponseBody
    public Profile removeProfileFromContext(@PathVariable(value="id") String contextId, @PathVariable(value="profileId") String profileId) throws SocialException {
        return this.socialContextService.removeProfileFromContext(contextId, profileId);
    }

    @RequestMapping(value={"/preferences/email"}, method={RequestMethod.PUT, RequestMethod.POST})
    @ResponseBody
    public boolean saveEmailTemplate(@RequestParam(required=true) String template, @RequestParam(required=true) String type) throws SocialException {
        if (!this.checkIfUserIsAdmin()) {
            throw new AuthenticationRequiredException("User must be logged in and must be social admin or context admin");
        }
        if (StringUtils.isBlank((CharSequence)template)) {
            throw new IllegalArgumentException("\"template\" param is cannot be blank");
        }
        if (StringUtils.isBlank((CharSequence)type) || !Arrays.asList("DAILY", "WEEKLY", "INSTANT", "APPROVEREMAIL", "APPROVER_RESULT_TEMPLATE").contains(type.toUpperCase())) {
            throw new IllegalArgumentException("\"type\" param can not be blank and must be on of the following values DAILY,WEEKLY,INSTANT,APPROVEREMAIL APPROVER_RESULT_TEMPLATE");
        }
        return this.contextPreferencesService.saveEmailTemplate(SocialSecurityUtils.getContext(), type.toUpperCase(), template);
    }

    @RequestMapping(value={"/preferences/email"}, method={RequestMethod.GET})
    @ResponseBody
    public Map<String, String> getSaveEmailTemplate(@RequestParam(required=true) String type) throws SocialException {
        if (!this.checkIfUserIsAdmin()) {
            throw new AuthenticationRequiredException("User must be logged in and must be social admin or context admin");
        }
        if (StringUtils.isBlank((CharSequence)type) || !Arrays.asList("DAILY", "WEEKLY", "INSTANT", "APPROVEREMAIL", "APPROVER_RESULT_TEMPLATE").contains(type.toUpperCase())) {
            throw new IllegalArgumentException("\"type\" param can not be blank and must be on of the following values DAILY,WEEKLY,INSTANT,APPROVEREMAIL APPROVER_RESULT_TEMPLATE");
        }
        HashMap<String, String> toReturn = new HashMap<String, String>();
        toReturn.put("template", this.contextPreferencesService.getEmailTemplate(SocialSecurityUtils.getContext(), type.toUpperCase()));
        return toReturn;
    }

    @RequestMapping(value={"/preferences/email/config"}, method={RequestMethod.GET})
    @ResponseBody
    public Map<String, Object> getEmailConfiguration() throws SocialException {
        if (!this.checkIfUserIsAdmin()) {
            throw new AuthenticationRequiredException("User must be logged in and must be social admin or context admin");
        }
        return this.contextPreferencesService.findEmailPreference(SocialSecurityUtils.getContext());
    }

    @RequestMapping(value={"/preferences/email/config"}, method={RequestMethod.POST, RequestMethod.PUT})
    @ResponseBody
    public Map<String, Object> setEmailConfiguration(@RequestParam(required=true) String host, @RequestParam(required=true) String encoding, @RequestParam(required=true) int port, @RequestParam(required=true) boolean auth, @RequestParam(required=true) String username, @RequestParam(required=true) String password, @RequestParam(required=true) boolean tls, @RequestParam(required=true) String replyTo, @RequestParam(required=true) String from, @RequestParam(required=true) int priority, @RequestParam(required=true) String subject) throws SocialException {
        if (!this.checkIfUserIsAdmin()) {
            throw new AuthenticationRequiredException("User must be logged in and must be social admin or context admin");
        }
        HashMap<String, Object> emailPref = new HashMap<String, Object>(11);
        emailPref.put("host", host);
        emailPref.put("encoding", encoding);
        emailPref.put("port", port);
        emailPref.put("auth", auth);
        emailPref.put("username", username);
        emailPref.put("password", password);
        emailPref.put("tls", tls);
        emailPref.put("replyTo", replyTo);
        emailPref.put("from", from);
        emailPref.put("priority", priority);
        emailPref.put("subject", subject);
        return this.contextPreferencesService.saveEmailConfig(SocialSecurityUtils.getContext(), emailPref);
    }

    @RequestMapping(value={"/preferences"}, method={RequestMethod.GET})
    @ResponseBody
    public Map<String, Object> getContextPreference() {
        if (!SocialSecurityUtils.getCurrentProfile().getUsername().equalsIgnoreCase("ANONYMOUS")) {
            return this.contextPreferencesService.getContextPreferences(SocialSecurityUtils.getContext());
        }
        throw new AuthenticationRequiredException("User must be logged in");
    }

    @RequestMapping(value={"/updatePreference"}, method={RequestMethod.POST, RequestMethod.PUT})
    @ResponseBody
    public boolean savePreferences(@RequestParam Map<String, Object> preferences) {
        if (!SocialSecurityUtils.getCurrentProfile().getUsername().equalsIgnoreCase("ANONYMOUS") && (SocialSecurityUtils.getCurrentProfile().hasRole("SOCIAL_ADMIN") || SocialSecurityUtils.getCurrentProfile().hasRole("SOCIAL_SUPERADMIN"))) {
            return this.contextPreferencesService.saveContextPreference(SocialSecurityUtils.getContext(), preferences);
        }
        throw new AuthenticationRequiredException("User must be logged in and must be social admin or context admin");
    }

    @RequestMapping(value={"/deletePreferences"}, method={RequestMethod.POST, RequestMethod.DELETE})
    @ResponseBody
    public boolean deletePreferences(@RequestParam String preferences) {
        if (!SocialSecurityUtils.getCurrentProfile().getUsername().equalsIgnoreCase("ANONYMOUS")) {
            if (SocialSecurityUtils.getCurrentProfile().hasRole("SOCIAL_ADMIN") || SocialSecurityUtils.getCurrentProfile().hasRole("SOCIAL_SUPERADMIN")) {
                this.contextPreferencesService.deleteContextPreference(SocialSecurityUtils.getContext(), Arrays.asList(preferences.split(",")));
            }
        } else {
            throw new AuthenticationRequiredException("User must be logged in and must be social admin or context admin");
        }
        return true;
    }

    private boolean checkIfUserIsAdmin() {
        return !SocialSecurityUtils.getCurrentProfile().getUsername().equalsIgnoreCase("ANONYMOUS") && SocialSecurityUtils.getCurrentProfile().hasRole("SOCIAL_ADMIN") || SocialSecurityUtils.getCurrentProfile().hasRole("SOCIAL_SUPERADMIN");
    }
}

