/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.social.domain;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.bson.types.ObjectId;
import org.craftercms.commons.jackson.mvc.annotations.Exclude;
import org.craftercms.commons.jackson.mvc.annotations.InjectValue;
import org.craftercms.commons.mongo.Document;
import org.craftercms.commons.mongo.FileInfo;
import org.craftercms.profile.api.Profile;
import org.jongo.marshall.jackson.oid.Id;
import org.springframework.beans.BeanUtils;

@Document(collectionName="ugc")
public class UGC<T extends UGC> {
    public static final String COLLECTION_NAME = "ugc";
    @Id
    private ObjectId id;
    private ArrayDeque<ObjectId> ancestors = new ArrayDeque();
    private String targetId;
    @Exclude
    private String contextId;
    private String subject;
    private String body;
    private ObjectId[] attachmentId;
    private String createdBy;
    private String lastModifiedBy;
    private Date createdDate;
    private Date lastModifiedDate;
    private boolean anonymousFlag;
    private Map<String, Object> attributes;
    private ArrayDeque<T> children = new ArrayDeque();
    private List<FileInfo> attachments = new ArrayList();
    @InjectValue(useProperty="createdBy")
    private Profile user = null;

    public UGC() {
    }

    public UGC(T base) {
        this();
        BeanUtils.copyProperties(base, (Object)this);
    }

    public UGC(String subject, String body, String targetId) {
        this();
        this.subject = subject;
        this.body = body;
        this.targetId = targetId;
    }

    public UGC(String subject, String body, String targetId, ArrayDeque<ObjectId> ancestors) {
        this();
        this.subject = subject;
        this.body = body;
        this.targetId = targetId;
        this.ancestors = ancestors;
    }

    public ObjectId getId() {
        return this.id;
    }

    public void setId(ObjectId id) {
        this.id = id;
    }

    public ArrayDeque<ObjectId> getAncestors() {
        return this.ancestors;
    }

    public void setAncestors(ArrayDeque<ObjectId> ancestors) {
        this.ancestors = ancestors;
    }

    public String getTargetId() {
        return this.targetId;
    }

    public void setTargetId(String targetId) {
        this.targetId = targetId;
    }

    public String getContextId() {
        return this.contextId;
    }

    public void setContextId(String contextId) {
        this.contextId = contextId;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getBody() {
        return this.body;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public ObjectId[] getAttachmentId() {
        return this.attachmentId;
    }

    public void setAttachmentId(ObjectId[] attachmentId) {
        this.attachmentId = attachmentId;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    public String getLastModifiedBy() {
        return this.lastModifiedBy;
    }

    public void setLastModifiedBy(String lastModifiedBy) {
        this.lastModifiedBy = lastModifiedBy;
    }

    public Date getCreatedDate() {
        return this.createdDate;
    }

    public void setCreatedDate(Date createdDate) {
        this.createdDate = createdDate;
    }

    public Date getLastModifiedDate() {
        return this.lastModifiedDate;
    }

    public void setLastModifiedDate(Date lastModifiedDate) {
        this.lastModifiedDate = lastModifiedDate;
    }

    public boolean isAnonymousFlag() {
        return this.anonymousFlag;
    }

    public void setAnonymousFlag(boolean anonymousFlag) {
        this.anonymousFlag = anonymousFlag;
    }

    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Map<String, Object> attributes) {
        this.attributes = attributes;
    }

    public ArrayDeque<T> getChildren() {
        return this.children;
    }

    public void setChildren(ArrayDeque<T> children) {
        this.children = children;
    }

    public List<FileInfo> getAttachments() {
        return this.attachments;
    }

    public void setAttachments(List<FileInfo> attachments) {
        this.attachments = attachments;
    }

    public Profile getUser() {
        return this.user;
    }

    public void setUser(Profile user) {
        this.user = user;
    }

    public boolean isMyParent(T ugc) {
        if (this.ancestors.isEmpty()) {
            return false;
        }
        return ((ObjectId)this.ancestors.getLast()).equals((Object)ugc.getId());
    }

    public <T extends UGC> boolean isMyChild(T ug) {
        if (ug.getAncestors().isEmpty()) {
            return false;
        }
        return ug.getAncestors().getLast().equals(this.id);
    }

    public String toString() {
        return "UGC{id=" + this.id + ", ancestors=" + StringUtils.join((Object[])new ArrayDeque[]{this.ancestors}) + ", targetId='" + this.targetId + "', subject='" + this.subject + "', createdBy='" + this.createdBy + "', lastModifiedBy='" + this.lastModifiedBy + "', createdDate=" + this.createdDate + ", lastModifiedDate=" + this.lastModifiedDate + ", anonymousFlag=" + this.anonymousFlag + ", attributes=" + this.attributes + "}";
    }
}

