/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.social.domain.notifications;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.HashSet;
import java.util.Set;
import org.craftercms.commons.i10n.I10nLogger;
import org.craftercms.commons.mongo.Document;
import org.craftercms.social.domain.notifications.ProfileWatchOptions;
import org.craftercms.social.util.LoggerFactory;
import org.jongo.marshall.jackson.oid.Id;

@Document(collectionName="watchList")
public class WatchedThread {
    @Id
    private String threadId;
    private Set<ProfileWatchOptions> watchers;
    @JsonIgnore
    private I10nLogger log = LoggerFactory.getLogger(WatchedThread.class);

    public WatchedThread() {
        this.watchers = new HashSet();
    }

    public void addWatcher(String profileId, String frequency) {
        ProfileWatchOptions toAdd = new ProfileWatchOptions(profileId, frequency);
        if (!this.watchers.contains(toAdd)) {
            this.watchers.add(toAdd);
            this.log.debug("logging.system.notification.userAddedWatching", new Object[]{profileId, this.threadId, frequency});
        } else {
            this.log.debug("logging.system.notification.userAlreadyWatching", new Object[]{profileId, this.threadId, frequency});
        }
    }

    public void removeWatcher(String profileId, String frequency) {
        if (this.watchers.remove(new ProfileWatchOptions(profileId, frequency))) {
            this.log.debug("logging.system.notification.userRemoveWatching", new Object[]{profileId, this.threadId, frequency});
        } else {
            this.log.debug("logging.system.notification.userUnableToRemove", new Object[]{profileId, this.threadId, frequency});
        }
    }

    public String getThreadId() {
        return this.threadId;
    }

    public void setThreadId(String threadId) {
        this.threadId = threadId;
    }

    public Set<ProfileWatchOptions> getWatchers() {
        return this.watchers;
    }

    public void setWatchers(Set<ProfileWatchOptions> watchers) {
        this.watchers = watchers;
    }

    public String toString() {
        return "WatchedThreads{threadId=" + this.threadId + ", watchers=" + this.watchers + "}";
    }
}

