/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.social.entitlement;

import java.util.Arrays;
import java.util.List;
import org.craftercms.commons.entitlements.exception.UnsupportedEntitlementException;
import org.craftercms.commons.entitlements.model.EntitlementType;
import org.craftercms.commons.entitlements.model.Module;
import org.craftercms.commons.entitlements.usage.EntitlementUsageProvider;
import org.craftercms.social.entitlement.SocialEntitlementUsageProvider;
import org.craftercms.social.repositories.SocialContextRepository;
import org.craftercms.social.repositories.ugc.UGCRepository;
import org.springframework.beans.factory.annotation.Required;

public class SocialEntitlementUsageProvider
implements EntitlementUsageProvider {
    protected SocialContextRepository socialContextRepository;
    protected UGCRepository ugcRepository;

    @Required
    public void setSocialContextRepository(SocialContextRepository socialContextRepository) {
        this.socialContextRepository = socialContextRepository;
    }

    @Required
    public void setUgcRepository(UGCRepository ugcRepository) {
        this.ugcRepository = ugcRepository;
    }

    public Module getModule() {
        return Module.SOCIAL;
    }

    public List<EntitlementType> getSupportedEntitlements() {
        return Arrays.asList(EntitlementType.SITE, EntitlementType.ITEM);
    }

    public int doGetEntitlementUsage(EntitlementType type) throws Exception {
        switch (1.$SwitchMap$org$craftercms$commons$entitlements$model$EntitlementType[type.ordinal()]) {
            case 1: {
                return (int)this.socialContextRepository.count();
            }
            case 2: {
                return (int)this.ugcRepository.count();
            }
        }
        throw new UnsupportedEntitlementException(Module.SOCIAL, type);
    }
}

