/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.social.moderation.impl;

import java.beans.ConstructorProperties;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathException;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.craftercms.social.domain.social.SocialUgc;
import org.craftercms.social.moderation.ModerationFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class BlackListModeration
implements ModerationFilter {
    private List<Pattern> registerPatterns;
    private List<String> registerWords;
    private Logger log = LoggerFactory.getLogger(BlackListModeration.class);

    @ConstructorProperties(value={"blackListFile"})
    public BlackListModeration(String blackListFile) throws SAXException, IOException, ParserConfigurationException, XPathException {
        this.loadBlackList(blackListFile);
        this.registerPatterns = new ArrayList();
        this.registerWords = new ArrayList();
    }

    public boolean needModeration(SocialUgc ugc) {
        boolean needsModeration = false;
        if (this.testRegex(ugc.getBody())) {
            needsModeration = true;
        } else if (this.testWord(ugc.getBody())) {
            needsModeration = true;
        }
        return needsModeration;
    }

    private boolean testRegex(String textContent) {
        boolean matchRegex = false;
        for (Pattern pattern : this.registerPatterns) {
            Matcher matcher = pattern.matcher(textContent);
            if (!matcher.find()) continue;
            this.log.debug("{} matches blacklist word {1}", (Object)textContent, (Object)pattern.toString());
            matchRegex = true;
            break;
        }
        return matchRegex;
    }

    private boolean testWord(String textContent) {
        boolean matchWord = false;
        for (String word : this.registerWords) {
            if (!textContent.toLowerCase().contains(word)) continue;
            this.log.debug("{} matches blacklist word {1}", (Object)textContent, (Object)word);
            matchWord = true;
            break;
        }
        return matchWord;
    }

    public String getName() {
        return "BlackList Moderation";
    }

    private void loadBlackList(String blackListFile) throws SAXException, IOException, ParserConfigurationException, XPathException {
        InputStream xmlFile = null;
        xmlFile = blackListFile.startsWith("classpath:") ? BlackListModeration.class.getResourceAsStream(blackListFile.split("classpath:")[1]) : new FileInputStream(blackListFile);
        this.log.debug("Loading File {} as blacklist file", (Object)blackListFile);
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setFeature("http://xml.org/sax/features/external-general-entities", false);
        dbf.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        dbf.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        dbf.setXIncludeAware(false);
        dbf.setExpandEntityReferences(false);
        Document doc = dbf.newDocumentBuilder().parse(xmlFile);
        this.addRegexRules(doc);
        this.addWordRules(doc);
        doc = null;
        xmlFile.close();
    }

    private void addWordRules(Document doc) throws XPathExpressionException {
        XPath xpath = XPathFactory.newInstance().newXPath();
        XPathExpression expr = xpath.compile("//word");
        Object result = expr.evaluate(doc, XPathConstants.NODESET);
        if (result != null && result instanceof NodeList) {
            NodeList nodes = (NodeList)result;
            this.log.debug("Found {} blacklist words", (Object)nodes.getLength());
            for (int i = 0; i < nodes.getLength(); ++i) {
                if (nodes.item(i).getNodeType() != 3) continue;
                String word = nodes.item(i).getTextContent().toLowerCase();
                this.registerWords.add(word);
                this.log.debug("Added {} as a blacklist word", (Object)word);
            }
        }
        xpath = null;
        expr = null;
        result = null;
    }

    private void addRegexRules(Document doc) throws XPathExpressionException {
        XPath xpath = XPathFactory.newInstance().newXPath();
        XPathExpression expr = xpath.compile("//pattern");
        Object result = expr.evaluate(doc, XPathConstants.NODESET);
        if (result != null && result instanceof NodeList) {
            NodeList nodes = (NodeList)result;
            this.log.debug("Found {} blacklist patterns", (Object)nodes.getLength());
            for (int i = 0; i < nodes.getLength(); ++i) {
                if (nodes.item(i).getNodeType() != 3) continue;
                this.addRegexRule(nodes.item(i).getTextContent());
            }
        }
        xpath = null;
        expr = null;
        result = null;
    }

    private void addRegexRule(String rule) {
        try {
            this.registerPatterns.add(Pattern.compile(rule));
            this.log.debug("Added {} as a blacklist rule");
        }
        catch (PatternSyntaxException e) {
            this.log.error("Unable to register {} as a blacklist pattern", (Object)rule);
        }
    }
}

