/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.social.moderation.impl;

import java.beans.ConstructorProperties;
import java.util.List;
import org.craftercms.social.domain.social.SocialUgc;
import org.craftercms.social.moderation.ModerationDecision;
import org.craftercms.social.moderation.ModerationFilter;

public class ModerationDecisionImpl
implements ModerationDecision {
    private List<ModerationFilter> filters;
    private int maxFlagsBeforeTrash = 10;

    @ConstructorProperties(value={"filters"})
    public ModerationDecisionImpl(List<ModerationFilter> filters) {
        this.filters = filters;
    }

    public boolean needModeration(SocialUgc ugc) {
        boolean needsModeration = false;
        for (ModerationFilter filter : this.filters) {
            if (!filter.needModeration(ugc)) continue;
            needsModeration = true;
            break;
        }
        return needsModeration;
    }

    public boolean isTrash(SocialUgc ugc) {
        return ugc.getFlags().size() >= this.maxFlagsBeforeTrash;
    }

    public void setMaxFlagsBeforeTrash(int maxFlags) {
        this.maxFlagsBeforeTrash = maxFlags;
    }
}

