/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.social.repositories.security.impl;

import java.util.List;
import java.util.Set;
import org.craftercms.commons.mongo.AbstractJongoRepository;
import org.craftercms.commons.mongo.MongoDataException;
import org.craftercms.social.domain.social.system.SocialSecurityAction;
import org.craftercms.social.repositories.security.PermissionRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PermissionRepositoryImpl
extends AbstractJongoRepository<SocialSecurityAction>
implements PermissionRepository {
    private Logger log = LoggerFactory.getLogger(PermissionRepositoryImpl.class);

    public boolean isAllowed(String action, Set<String> profileRoles, String context) throws MongoDataException {
        try {
            String query = this.getQueryFor("social.permissions.isAllowed");
            return this.findOne(query, new Object[]{action, profileRoles, context}) != null;
        }
        catch (MongoDataException ex) {
            this.log.error("Unable to check if action belongs to given profile", (Throwable)ex);
            throw new MongoDataException("Unable to check action for given profile roles");
        }
    }

    public Iterable<SocialSecurityAction> findActions(String context) throws MongoDataException {
        String query = this.getQueryFor("social.permissions.byContextId");
        return this.find(query, new Object[]{context});
    }

    public SocialSecurityAction updateSecurityAction(String context, String actionName, List<String> roles) throws MongoDataException {
        String query = this.getQueryFor("social.permissions.byContextIdAndActionName");
        String update = this.getQueryFor("social.permissions.updateRoles");
        SocialSecurityAction securityAction = (SocialSecurityAction)this.findOne(query, new Object[]{context, actionName});
        if (securityAction == null) {
            return null;
        }
        this.update(securityAction.getId().toString(), update, false, false, new Object[]{roles});
        return (SocialSecurityAction)this.findOne(query, new Object[]{context, actionName});
    }
}

