/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.social.repositories.system.impl;

import com.mongodb.MongoException;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.craftercms.commons.collections.IterableUtils;
import org.craftercms.commons.i10n.I10nLogger;
import org.craftercms.commons.mongo.AbstractJongoRepository;
import org.craftercms.commons.mongo.MongoDataException;
import org.craftercms.social.domain.audit.AuditLog;
import org.craftercms.social.exceptions.SocialException;
import org.craftercms.social.repositories.system.AuditRepository;
import org.craftercms.social.services.notification.impl.AuditServiceImpl;
import org.craftercms.social.services.system.ContextPreferencesService;
import org.craftercms.social.util.LoggerFactory;
import org.craftercms.social.util.ProfileUtils;
import org.craftercms.social.util.profile.ProfileAggregator;
import org.jongo.Aggregate;
import org.slf4j.Logger;

public class AuditRepositoryImpl
extends AbstractJongoRepository<AuditLog>
implements AuditRepository {
    private I10nLogger log = LoggerFactory.getLogger(AuditServiceImpl.class);
    private Logger logger = org.slf4j.LoggerFactory.getLogger(AuditRepositoryImpl.class);
    private ProfileAggregator profileAggregator;
    private ContextPreferencesService contextPreferencesService;

    public void deleteByIds(List<String> ids) throws SocialException {
        String query = this.getQueryFor("social.system.audit.deleteByIds");
        this.log.debug("logging.system.auditAboutToDelete", new Object[]{ids});
        try {
            this.remove(query, new Object[]{ids});
        }
        catch (MongoDataException e) {
            throw new SocialException("Unable to delete Audits", (Throwable)e);
        }
    }

    public List<AuditLog> getByDate(String context, Date from, Date to) throws SocialException {
        String query = this.getQueryFor("social.system.audit.byDateRangeCTX");
        this.log.debug("logging.system.findingAuditsByCTX", new Object[]{context, from, to});
        try {
            return IterableUtils.toList((Iterable)this.find(query, new Object[]{context, from, to}));
        }
        catch (MongoDataException e) {
            throw new SocialException("Unable to find Log Audits", (Throwable)e);
        }
    }

    public List<AuditLog> getByDate(Date from, Date to) throws SocialException {
        String query = this.getQueryFor("social.system.audit.byDateRange");
        this.log.debug("logging.system.findingAuditsBy", new Object[]{from, to});
        try {
            return IterableUtils.toList((Iterable)this.find(query, new Object[]{from, to}));
        }
        catch (MongoDataException e) {
            throw new SocialException("Unable to find Log Audits", (Throwable)e);
        }
    }

    public Iterable<AuditLog> getNotificationsToSend(String threadId, Date from, Date to) throws SocialException {
        String query = this.getQueryFor("social.system.audit.byDateRange");
        this.log.debug("social.notification.notificationToSend", new Object[]{threadId, from, to});
        try {
            return IterableUtils.toList((Iterable)this.find(query, new Object[]{from, to}));
        }
        catch (MongoDataException e) {
            throw new SocialException("Unable to find Log Audits", (Throwable)e);
        }
    }

    public List<HashMap> getNotificationDigest(String id, Date from, Date to, List<String> profilesToExclude) throws SocialException {
        try {
            String querypt1 = this.getQueryFor("social.notification.audit.getNotificationDigestPt1");
            String querypt2 = this.getQueryFor("social.notification.audit.getNotificationDigestPt2");
            String[] idParts = id.split("/");
            Map preferences = this.contextPreferencesService.getContextPreferences(idParts[0]);
            String unwantedStatus = ((HashMap)preferences.get("preferences")).get("hiddenUgcStatus").toString();
            Aggregate agregation = this.getCollection().aggregate(querypt1, new Object[]{idParts[1], idParts[0], Arrays.asList(unwantedStatus.split(",")), profilesToExclude, from, to});
            this.logger.debug("NotificationQ\n\r {} {} {} {} {} {} {}", new Object[]{querypt1, idParts[1], idParts[0], Arrays.asList(unwantedStatus.split(",")), profilesToExclude, from, to});
            this.logger.debug("NotificationQ2\n\r {}", (Object)querypt2);
            List preResults = IterableUtils.toList((Iterable)agregation.and(querypt2, new Object[0]).as(HashMap.class));
            this.logger.debug("PreResults size {}", (Object)preResults.size());
            for (HashMap preResult : preResults) {
                List ugcList = (List)preResult.get("ugcList");
                for (HashMap ugc : ugcList) {
                    if (Boolean.parseBoolean(ugc.get("anonymousFlag").toString())) {
                        ugc.put("createdBy", ProfileUtils.getAnonymousProfile());
                        ugc.put("lastModifiedBy", ProfileUtils.getAnonymousProfile());
                        continue;
                    }
                    if (!ugc.containsKey("lastModifiedBy") || !ugc.containsKey("createdBy")) continue;
                    ugc.put("createdBy", this.profileAggregator.getProfile(ugc.get("createdBy").toString()));
                    ugc.put("lastModifiedBy", this.profileAggregator.getProfile(ugc.get("lastModifiedBy").toString()));
                }
            }
            return preResults;
        }
        catch (MongoException ex) {
            throw new SocialException("Unable to Generate Notification Digest ", (Throwable)ex);
        }
    }

    public void setProfileAggregatorImpl(ProfileAggregator profileAggregator) {
        this.profileAggregator = profileAggregator;
    }

    public void setContextPreferencesService(ContextPreferencesService contextPreferencesService) {
        this.contextPreferencesService = contextPreferencesService;
    }
}

