/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.social.repositories.system.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.mongodb.MongoException;
import com.mongodb.WriteResult;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.craftercms.commons.i10n.I10nLogger;
import org.craftercms.commons.mongo.AbstractJongoRepository;
import org.craftercms.social.domain.system.ContextPreferences;
import org.craftercms.social.exceptions.SocialException;
import org.craftercms.social.repositories.system.ContextPreferencesRepository;
import org.craftercms.social.util.LoggerFactory;

public class ContextPreferencesRepositoryImpl
extends AbstractJongoRepository<ContextPreferences>
implements ContextPreferencesRepository {
    private I10nLogger logger = LoggerFactory.getLogger(ContextPreferencesRepositoryImpl.class);

    public Map<String, String> getEmailPreference(String contextId) throws SocialException {
        try {
            String query = this.getQueryFor("social.system.preferences.emailPreferencesByContextId");
            HashMap tmp = (HashMap)this.getCollection().findOne(query, new Object[]{contextId}).projection("{email:1,_id:0}").as(HashMap.class);
            if (tmp == null || !tmp.containsKey("email")) {
                throw new SocialException("Current context " + contextId + "is missing email configuration");
            }
            return (Map)tmp.get("email");
        }
        catch (MongoException ex) {
            throw new SocialException("Unable to read email preferences for " + contextId);
        }
    }

    public Map<String, Object> saveEmailConfig(String contextId, Map<String, Object> emailPref) throws SocialException {
        try {
            String fQuery = this.getQueryFor("social.system.preferences.emailPreferencesByContextId");
            String uQuery = this.getQueryFor("social.system.preferences.updateContextEmailPref");
            this.getCollection().update(fQuery, new Object[]{contextId}).with(uQuery, new Object[]{emailPref.get("host"), emailPref.get("encoding"), emailPref.get("port"), emailPref.get("auth"), emailPref.get("username"), emailPref.get("password"), emailPref.get("tls"), emailPref.get("replyTo"), emailPref.get("from"), emailPref.get("priority"), emailPref.get("subject")});
            return emailPref;
        }
        catch (MongoException ex) {
            throw new SocialException("Unable to read email preferences for " + contextId);
        }
    }

    public String findNotificationTemplate(String contextId, String notificationType) throws SocialException {
        try {
            String query = this.getQueryFor("social.system.preferences.notificationEmailByType");
            Map qResult = (Map)this.getCollection().findOne(query, new Object[]{contextId, notificationType.toUpperCase()}).projection("{\"templates.$\":1,_id:0}").as(Map.class);
            if (qResult == null) {
                return null;
            }
            List templates = (List)qResult.get("templates");
            if (templates == null) {
                return null;
            }
            if (templates.isEmpty()) {
                throw new SocialException("No template for type" + notificationType + " has been define for context " + contextId);
            }
            if (templates.size() > 1) {
                this.logger.warn("logging.system.notification.multipleTemplatesForType", new Object[]{notificationType, contextId});
            }
            return ((Map)templates.get(0)).get("template").toString();
        }
        catch (MongoException ex) {
            throw new SocialException("Unable to get Notification Template for " + contextId + " of type" + notificationType);
        }
    }

    public Map<String, Object> getContextPreferences(String contextId) {
        try {
            String byId = this.getQueryFor("social.system.preferences.emailPreferencesByContextId");
            return (Map)this.getCollection().findOne(byId, new Object[]{contextId}).projection("{preferences:1,_id:0}").as(HashMap.class);
        }
        catch (MongoException ex) {
            return new HashMap<String, Object>();
        }
    }

    public Map<String, Object> getContextAllPreferences(String contextId) {
        try {
            String byId = this.getQueryFor("social.system.preferences.emailPreferencesByContextId");
            return (Map)this.getCollection().findOne(byId, new Object[]{contextId}).as(HashMap.class);
        }
        catch (MongoException ex) {
            return new HashMap<String, Object>();
        }
    }

    public boolean setContextPreferences(Map<String, Object> preferences, String contextId) {
        try {
            String preferencesString = new ObjectMapper().writeValueAsString(preferences);
            String byId = this.getQueryFor("social.system.preferences.emailPreferencesByContextId");
            this.getCollection().update(byId, new Object[]{contextId}).with("{$set: " + preferencesString + "}");
            return true;
        }
        catch (JsonProcessingException | MongoException e) {
            this.logger.error("Unable to delete context Preferences", e, new Object[0]);
            return false;
        }
    }

    public boolean deleteContextPreferences(String context, List<String> preferences) {
        try {
            String byId = this.getQueryFor("social.system.preferences.emailPreferencesByContextId");
            Object toUnset = "";
            Iterator<String> iter = preferences.iterator();
            while (iter.hasNext()) {
                String key = iter.next();
                toUnset = (String)toUnset + "preferences." + key + ":1";
                if (!iter.hasNext()) continue;
                toUnset = (String)toUnset + ",";
            }
            this.getCollection().update(byId, new Object[]{context}).with("{$unset:{" + (String)toUnset + "}}");
            return true;
        }
        catch (MongoException e) {
            this.logger.error("Unable to delete context Preferences", (Throwable)e, new Object[0]);
            return false;
        }
    }

    public void saveEmailPreference(String contextId, Map<String, Object> emailPreferences) throws SocialException {
        try {
            String query = this.getQueryFor("social.system.preferences.savePreferencesByContextId");
            String findQ = this.getQueryFor("social.system.preferences.emailPreferencesByContextId");
            this.getCollection().update(findQ, new Object[]{contextId}).upsert().with(query, new Object[]{emailPreferences.get("host"), emailPreferences.get("encoding"), emailPreferences.get("port"), emailPreferences.get("auth"), emailPreferences.get("username"), emailPreferences.get("password"), emailPreferences.get("tls"), emailPreferences.get("replyTo"), emailPreferences.get("from"), emailPreferences.get("priority"), emailPreferences.get("subject")});
        }
        catch (MongoException ex) {
            throw new SocialException("Unable to read email preferences for " + contextId);
        }
    }

    public void saveAllContextPreferences(String contextId, Map<String, Object> newPreferences) throws SocialException {
        try {
            this.getCollection().save(newPreferences);
        }
        catch (MongoException ex) {
            throw new SocialException("Unable to save email Preferences");
        }
    }

    public boolean saveEmailTemplate(String context, String type, String template) throws SocialException {
        try {
            String findQ = this.getQueryFor("social.system.preferences.byContextAndTemplateType");
            String updateQ = this.getQueryFor("social.system.preferences.updateContextTemplateType");
            WriteResult r = this.getCollection().update(findQ, new Object[]{context, type.toUpperCase()}).with(updateQ, new Object[]{template});
            return r.getN() == 1;
        }
        catch (MongoException ex) {
            throw new SocialException("Unable to update Email template", (Throwable)ex);
        }
    }
}

