/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.social.repositories.system.notifications.impl;

import com.mongodb.MongoException;
import java.util.List;
import java.util.Map;
import org.craftercms.commons.collections.IterableUtils;
import org.craftercms.commons.mongo.AbstractJongoRepository;
import org.craftercms.commons.mongo.MongoDataException;
import org.craftercms.social.domain.notifications.ThreadsToNotify;
import org.craftercms.social.domain.notifications.WatchedThread;
import org.craftercms.social.exceptions.NotificationException;
import org.craftercms.social.exceptions.SocialException;
import org.craftercms.social.repositories.system.notifications.WatchedThreadsRepository;
import org.jongo.Aggregate;
import org.jongo.ResultHandler;

public class WatchedThreadsRepositoryImpl
extends AbstractJongoRepository<WatchedThread>
implements WatchedThreadsRepository {
    public void removeWatcher(String thread, String userId) throws NotificationException {
        try {
            String pullQuery = this.getQueryFor("social.notifications.removeUserWatch");
            String find = this.getQueryFor("social.notifications.findById");
            this.getCollection().findAndModify(find, new Object[]{thread}).with(pullQuery, new Object[]{userId}).as(this.clazz);
        }
        catch (MongoException ex) {
            throw new NotificationException("Unable to removeWatcher Watched Thread", (Throwable)ex);
        }
    }

    public void addWatcher(String thread, String userId, String frequency) throws NotificationException {
        try {
            String addQuery = this.getQueryFor("social.notifications.addUserWatch");
            String find = this.getQueryFor("social.notifications.findById");
            this.getCollection().findAndModify(find, new Object[]{thread}).with(addQuery, new Object[]{userId, frequency}).as(this.clazz);
        }
        catch (MongoException ex) {
            throw new NotificationException("Unable to add Watcher Watched Thread", (Throwable)ex);
        }
    }

    public WatchedThread isUserSubscribe(String threadId, String profileId) throws MongoDataException {
        String query = this.getQueryFor("social.notifications.isBeenWatched");
        return (WatchedThread)this.findOne(query, new Object[]{threadId, profileId});
    }

    public Iterable<WatchedThread> findAllWithWatchers() throws NotificationException {
        try {
            String query = this.getQueryFor("social.notifications.byWatchersNotEmpty");
            return this.find(query);
        }
        catch (MongoDataException ex) {
            throw new NotificationException("Unable to find threads with watchers", (Throwable)ex);
        }
    }

    public List<ThreadsToNotify> findProfilesToSend(String type) throws NotificationException {
        try {
            String aggregationQuerypt1 = this.getQueryFor("social.notification.getProfilePt1");
            String aggregationQuerypt2 = this.getQueryFor("social.notification.getProfilePt2");
            String aggregationQuerypt3 = this.getQueryFor("social.notification.getProfilePt3");
            String aggregationQuerypt4 = this.getQueryFor("social.notification.getProfilePt4");
            Aggregate aggregation = this.getCollection().aggregate(aggregationQuerypt1);
            aggregation.and(aggregationQuerypt2, new Object[0]).and(aggregationQuerypt3, new Object[]{type}).and(aggregationQuerypt4, new Object[0]);
            return IterableUtils.toList((Iterable)aggregation.as(ThreadsToNotify.class));
        }
        catch (MongoException ex) {
            throw new NotificationException("Unable to find Profiles to notify", (Throwable)ex);
        }
    }

    public List<Map> findUserWatchedThreads(String profileId) throws SocialException {
        String query = this.getQueryFor("social.notification.byWatcherId1");
        String query2 = this.getQueryFor("social.notification.byWatcherId2");
        String query3 = this.getQueryFor("social.notification.byWatcherId3");
        try {
            return IterableUtils.toList((Iterable)this.getCollection().aggregate(query).and(query2, new Object[]{profileId}).and(query3, new Object[0]).map((ResultHandler)new /* Unavailable Anonymous Inner Class!! */));
        }
        catch (MongoException ex) {
            throw new SocialException("Unable to read watched threads for user", (Throwable)ex);
        }
    }
}

