/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.social.repositories.ugc.impl;

import com.mongodb.MongoException;
import com.mongodb.util.JSONParseException;
import java.lang.invoke.CallSite;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.Transformer;
import org.apache.commons.lang3.StringUtils;
import org.bson.types.ObjectId;
import org.craftercms.commons.collections.IterableUtils;
import org.craftercms.commons.mongo.MongoDataException;
import org.craftercms.social.controllers.rest.v3.comments.exceptions.UGCNotFound;
import org.craftercms.social.domain.UGC;
import org.craftercms.social.domain.social.ModerationStatus;
import org.craftercms.social.domain.social.SocialUgc;
import org.craftercms.social.exceptions.IllegalUgcException;
import org.craftercms.social.repositories.SocialJongoRepository;
import org.craftercms.social.repositories.TreeUGC;
import org.craftercms.social.repositories.ugc.UGCRepository;
import org.craftercms.social.repositories.ugc.support.BaseTreeUgc;
import org.craftercms.social.services.system.TenantConfigurationService;
import org.jongo.Aggregate;
import org.jongo.Find;
import org.jongo.ResultHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UGCRepositoryImpl<T extends UGC>
extends SocialJongoRepository
implements UGCRepository {
    private Logger log = LoggerFactory.getLogger(UGCRepositoryImpl.class);
    private TenantConfigurationService tenantConfigurationService;

    public Iterable<UGC> findAll() throws MongoDataException {
        throw new UnsupportedOperationException("Disable for security reasons , use findAllUgc(String,String)");
    }

    public List<T> findChildrenOf(String ugcId, int childrenCount, String contextId) throws MongoDataException {
        try {
            String pt1 = this.getQueryFor("social.ugc.getTree1");
            String pt2 = this.getQueryFor("social.ugc.getTree2");
            String pt3 = this.getQueryFor("social.ugc.getTree3");
            String pt4 = this.getQueryFor("social.ugc.getTree4");
            String pt5 = this.getQueryFor("social.ugc.getTree5");
            String pt6 = this.getQueryFor("social.ugc.getTree6");
            String pt7 = this.getQueryFor("social.ugc.getTree7");
            String pt8 = this.getQueryFor("social.ugc.getTree8");
            String pt9 = this.getQueryFor("social.ugc.getTree9");
            String pt10 = this.getQueryFor("social.ugc.getTree10");
            if (!ObjectId.isValid((String)ugcId)) {
                throw new IllegalArgumentException("Given UGC id is not valid");
            }
            ObjectId id = new ObjectId(ugcId);
            Aggregate aggregation = this.getCollection().aggregate(pt1);
            aggregation.and(pt2, new Object[]{contextId, Arrays.asList(id), id});
            aggregation.and(pt3, new Object[0]).and(pt4, new Object[0]).and(pt5, new Object[0]).and(pt6, new Object[0]).and(pt7, new Object[0]).and(pt8, new Object[0]);
            aggregation.and(pt9, new Object[]{childrenCount});
            aggregation.and(pt10, new Object[0]);
            return this.toUgcList(IterableUtils.toList((Iterable)aggregation.as(this.ugcFactory.getTreeClass())));
        }
        catch (Exception ex) {
            this.log.error("Unable to ", (Throwable)ex);
            throw new MongoDataException("Unable to find children of given UGC", (Throwable)ex);
        }
    }

    public UGC findById(String id) throws MongoDataException {
        throw new UnsupportedOperationException("Disable for security reasons , use findUgc(String,String)");
    }

    public Iterable<T> findByTargetId(String targetId, String contextId) throws MongoDataException {
        String query = this.getQueryFor("social.ugc.byTargetId");
        return this.find(query, new Object[]{contextId, targetId});
    }

    public void deleteAttribute(String ugcId, String contextId, String[] attributesName) throws MongoDataException {
        String query = this.getQueryFor("social.ugc.byContextAndId");
        String delete = this.getQueryFor("social.ugc.deleteAttribute");
        try {
            if (!ObjectId.isValid((String)ugcId)) {
                throw new IllegalArgumentException("Given UGC Id is not valid");
            }
            HashMap<CallSite, Integer> map = new HashMap<CallSite, Integer>();
            for (String attributeName : attributesName) {
                map.put((CallSite)((Object)("attributes." + attributeName)), -1);
            }
            this.getCollection().update(query, new Object[]{new ObjectId(ugcId), contextId}).with(delete, new Object[]{map});
        }
        catch (MongoException ex) {
            this.log.error("Unable to delete attribute " + attributesName + " for UGC " + ugcId + "of contextId " + contextId, (Throwable)ex);
            throw new MongoDataException("Unable to delete attribute of a ugc", (Throwable)ex);
        }
    }

    public T findUGC(String contextId, String ugcId) throws MongoDataException {
        String query = this.getQueryFor("social.ugc.byContextAndId");
        UGC toReturn = null;
        if (!ObjectId.isValid((String)ugcId)) {
            throw new IllegalArgumentException("Given UGC " + ugcId + " is invalid");
        }
        toReturn = (UGC)this.findOne(query, new Object[]{new ObjectId(ugcId), contextId});
        return (T)toReturn;
    }

    public void setAttributes(String ugcId, String contextId, Map attributes) throws MongoDataException {
        String query = this.getQueryFor("social.ugc.byContextAndId");
        String update = this.getQueryFor("social.ugc.addAttributes");
        try {
            if (!ObjectId.isValid((String)ugcId)) {
                throw new IllegalArgumentException("Given UGC Id is not valid");
            }
            this.getCollection().update(query, new Object[]{new ObjectId(ugcId), contextId}).with(update, new Object[]{attributes});
        }
        catch (MongoException ex) {
            this.log.error("Unable to delete attribute " + attributes + " for UGC " + ugcId + "of contextId " + contextId, (Throwable)ex);
            throw new MongoDataException("Unable to delete attribute of a ugc", (Throwable)ex);
        }
    }

    public void deleteUgc(String ugcId, String contextId) throws MongoDataException {
        String delete = this.getQueryFor("social.ugc.byIds");
        if (!ObjectId.isValid((String)ugcId)) {
            throw new IllegalArgumentException("Given UGC Id is not valid");
        }
        Collection toDelete = CollectionUtils.collect((Iterable)this.findChildrenOf(ugcId, Integer.MAX_VALUE, contextId), (Transformer)new /* Unavailable Anonymous Inner Class!! */);
        this.log.debug("Deleting UGC's {}", (Object)toDelete);
        this.remove(delete, new Object[]{toDelete});
    }

    public Iterable<T> findByUserQuery(String contextId, String query, String sort, int start, int limit) throws MongoDataException {
        try {
            StringBuffer realQuery = new StringBuffer(query);
            realQuery.insert(1, "contextId:\"" + contextId + "\", ");
            Find find = this.getCollection().find(realQuery.toString());
            if (!StringUtils.isBlank((CharSequence)sort)) {
                find.sort(sort);
            }
            return find.skip(start).limit(limit).as(this.clazz);
        }
        catch (MongoException | JSONParseException ex) {
            this.log.error("Unable to Find UGC with given User query " + query + "sorted by " + sort, ex);
            throw new MongoDataException("Unable to find ugcs by user query", ex);
        }
    }

    public Iterable<T> findChildren(String ugcId, String targetId, String contextId, int start, int limit, List sortOrder, int upToLevel) throws MongoDataException, UGCNotFound {
        try {
            if (!ObjectId.isValid((String)ugcId)) {
                throw new IllegalArgumentException("Given UGC id is not valid");
            }
            UGC parent = this.findUGC(contextId, ugcId);
            if (parent == null) {
                throw new IllegalUgcException("Ugc does not exist for given id and context");
            }
            if (parent instanceof SocialUgc && (((SocialUgc)parent).getModerationStatus() == ModerationStatus.TRASH || ((SocialUgc)parent).getModerationStatus() == ModerationStatus.SPAM)) {
                throw new UGCNotFound("Parent UGC is on Spam or thrash");
            }
            Object ancestors = parent.getAncestors().clone();
            ((ArrayDeque)ancestors).addLast(parent.getId());
            String query = this.getQueryFor("social.ugc.byContextTargetAncestorsExact");
            String hiddenStatus = (String)this.tenantConfigurationService.getProperty(contextId, "hiddenUgcStatus");
            Find find = this.getCollection().find(query, new Object[]{contextId, targetId, ancestors, ModerationStatus.listOfModerationStatus((String)hiddenStatus)});
            return this.getUgcsToFind(find, targetId, contextId, start, limit, sortOrder, ((ArrayDeque)ancestors).size() + upToLevel);
        }
        catch (MongoException ex) {
            this.log.error("Unable to find children of " + ugcId, (Throwable)ex);
            throw new MongoDataException("Unable to find children of given UGC", (Throwable)ex);
        }
    }

    public Iterable<T> findByTargetId(String targetId, String contextId, int start, int limit, List sortOrder, int upToLevel) throws MongoDataException {
        try {
            String query = this.getQueryFor("social.ugc.byTargetIdRootLvl");
            String hiddenStatus = (String)this.tenantConfigurationService.getProperty(contextId, "hiddenUgcStatus");
            Find find = this.getCollection().find(query, new Object[]{contextId, targetId, ModerationStatus.listOfModerationStatus((String)hiddenStatus)});
            return this.getUgcsToFind(find, targetId, contextId, start, limit, sortOrder, upToLevel);
        }
        catch (MongoException ex) {
            this.log.error("Unable to Find UGC's " + targetId + "children", (Throwable)ex);
            throw new MongoDataException("Unable to find ugcs by user query", (Throwable)ex);
        }
    }

    private Iterable<T> getUgcsToFind(Find initialFind, String targetId, String contextId, int start, int limit, List sortOrder, int upToLevel) throws MongoDataException {
        if (CollectionUtils.isEmpty((Collection)sortOrder)) {
            initialFind.sort(this.getQueryFor("social.ugc.defaultSort"));
        } else {
            initialFind.sort(this.createSortQuery(sortOrder));
        }
        initialFind.projection("{_id:1}");
        List listOfIds = IterableUtils.toList((Iterable)initialFind.skip(start).limit(limit).map((ResultHandler)new /* Unavailable Anonymous Inner Class!! */));
        String finalQuery = this.getQueryFor("social.ugc.byTargetIdRootNLvl");
        finalQuery = finalQuery.replaceAll("%@", String.valueOf(upToLevel));
        String hiddenStatus = (String)this.tenantConfigurationService.getProperty(contextId, "hiddenUgcStatus");
        Find finalMongoQuery = this.getCollection().find(finalQuery, new Object[]{targetId, contextId, ModerationStatus.listOfModerationStatus((String)hiddenStatus), listOfIds, listOfIds});
        if (CollectionUtils.isEmpty((Collection)sortOrder)) {
            finalMongoQuery.sort(this.getQueryFor("social.ugc.defaultSort"));
        } else {
            finalMongoQuery.sort(this.createSortQuery(sortOrder));
        }
        return finalMongoQuery.as(this.clazz);
    }

    public long countByTargetId(String contextId, String threadId, int levels) throws MongoDataException {
        try {
            String hiddenStatus = (String)this.tenantConfigurationService.getProperty(contextId, "hiddenUgcStatus");
            return this.count(this.getQueryFor("social.ugc.byTargetIdWithFixLvl"), new Object[]{contextId, threadId, levels, ModerationStatus.listOfModerationStatus((String)hiddenStatus)});
        }
        catch (MongoException ex) {
            this.log.error("Unable to count ugc for context " + contextId + "and target " + threadId, (Throwable)ex);
            throw new MongoDataException("Unable to count ugc for context and target", (Throwable)ex);
        }
    }

    public long countChildrenOf(String contextId, String ugcId) throws MongoDataException {
        try {
            if (!ObjectId.isValid((String)ugcId)) {
                throw new IllegalArgumentException("Given UGC id is not valid");
            }
            UGC parent = this.findUGC(contextId, ugcId);
            Object ancestors = parent.getAncestors().clone();
            ((ArrayDeque)ancestors).addLast(parent.getId());
            return this.count(this.getQueryFor("social.ugc.byContextAncestorsExact"), new Object[]{contextId, ancestors, ((ArrayDeque)ancestors).size()});
        }
        catch (MongoException ex) {
            this.log.error("Unable to count ugc for context " + contextId + "and id " + ugcId, (Throwable)ex);
            throw new MongoDataException("Unable to count ugc for context and target", (Throwable)ex);
        }
    }

    public Iterable<T> findByModerationStatus(ModerationStatus status, String targetId, String contextId, int start, int limit, List sortOrder) throws MongoDataException {
        Find query = StringUtils.isBlank((CharSequence)targetId) ? this.getCollection().find(this.getQueryFor("social.ugc.byModerationStatus"), new Object[]{status, contextId}) : this.getCollection().find(this.getQueryFor("social.ugc.byModerationStatusAndTargetId"), new Object[]{status, contextId, targetId});
        return query.sort(this.createSortQuery(sortOrder)).skip(start).limit(limit).as(this.clazz);
    }

    public long countFindByModerationStatus(ModerationStatus status, String targetId, String contextId) throws MongoDataException {
        if (StringUtils.isBlank((CharSequence)targetId)) {
            return this.count(this.getQueryFor("social.ugc.byModerationStatus"), new Object[]{status, contextId});
        }
        return this.count(this.getQueryFor("social.ugc.byModerationStatusAndTargetId"), new Object[]{status, contextId, targetId});
    }

    public Iterable<T> findAllFlagged(String context, int start, int pageSize, List sortOrder) {
        String query = this.getQueryFor("social.ugc.byFlaggedStatus");
        Find f = this.getCollection().find(query, new Object[]{context, ModerationStatus.TRASH});
        if (CollectionUtils.isEmpty((Collection)sortOrder)) {
            f.sort(this.getQueryFor("social.ugc.defaultSort"));
        } else {
            f.sort(this.createSortQuery(sortOrder));
        }
        f.skip(start).limit(pageSize);
        return f.as(this.clazz);
    }

    public long countAllFlagged(String context, int start, int pageSize, List sortOrder) {
        String query = this.getQueryFor("social.ugc.byFlaggedStatus");
        return this.getCollection().count(query, new Object[]{context, ModerationStatus.TRASH});
    }

    protected List<T> toUgcList(List<BaseTreeUgc> as) {
        ArrayList<UGC> ugcList = new ArrayList<UGC>(as.size());
        for (TreeUGC treeUGC : as) {
            ugcList.add((UGC)treeUGC.getUGC());
        }
        return ugcList;
    }

    public void setTenantConfigurationServiceImpl(TenantConfigurationService tenantConfigurationService) {
        this.tenantConfigurationService = tenantConfigurationService;
    }
}

