/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.social.security;

import java.util.List;
import java.util.concurrent.ConcurrentSkipListSet;
import org.craftercms.commons.mongo.MongoDataException;
import org.craftercms.commons.security.permissions.Permission;
import org.craftercms.security.exception.AccessDeniedException;
import org.craftercms.social.repositories.security.PermissionRepository;

public class SocialPermission
implements Permission {
    private final String contextId;
    private List<String> profileRoles;
    private PermissionRepository repository;

    public SocialPermission(List<String> profileRoles, PermissionRepository repository, String contextId) {
        this.profileRoles = profileRoles;
        this.repository = repository;
        this.contextId = contextId;
    }

    public boolean isAllowed(String action) {
        try {
            ConcurrentSkipListSet<String> coll = new ConcurrentSkipListSet<String>();
            for (String profileRole : this.profileRoles) {
                if (coll.contains(profileRole)) continue;
                coll.add(profileRole);
            }
            return this.repository.isAllowed(action, coll, this.contextId);
        }
        catch (MongoDataException e) {
            throw new AccessDeniedException("Unable to find Action", (Throwable)e);
        }
    }
}

