/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.social.security;

import org.bson.types.ObjectId;
import org.craftercms.commons.security.exception.PermissionException;
import org.craftercms.commons.security.permissions.Permission;
import org.craftercms.commons.security.permissions.PermissionResolver;
import org.craftercms.profile.api.Profile;
import org.craftercms.social.domain.UGC;
import org.craftercms.social.domain.social.Flag;
import org.craftercms.social.exceptions.UGCException;
import org.craftercms.social.repositories.security.PermissionRepository;
import org.craftercms.social.security.SocialPermission;
import org.craftercms.social.security.SocialSecurityUtils;
import org.craftercms.social.services.ugc.UGCService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SocialPermissionResolver<T>
implements PermissionResolver<Profile, T> {
    protected PermissionRepository permissionRepository;
    protected UGCService ugcService;
    private Logger log = LoggerFactory.getLogger(SocialPermissionResolver.class);

    public Permission getGlobalPermission(Profile subject) throws PermissionException {
        return this.getPermission(subject, null);
    }

    public Permission getPermission(Profile subject, T object) throws PermissionException {
        Flag f;
        if (object instanceof String) {
            String ugcId = (String)object;
            if (ObjectId.isValid((String)ugcId)) {
                try {
                    UGC ugc = this.ugcService.read(ugcId, SocialSecurityUtils.getContext());
                    if (ugc != null && subject.getId().equals((Object)ugc.getCreatedBy())) {
                        subject.getRoles().add("OWNER");
                    }
                }
                catch (UGCException e) {
                    this.log.error("Unable to find UGC with id " + ugcId, (Throwable)e);
                }
            }
        } else if (object instanceof Flag && (f = (Flag)object).getUserId().equalsIgnoreCase(subject.getId().toString())) {
            subject.getRoles().add("OWNER");
        }
        return new SocialPermission(SocialSecurityUtils.getSocialRoles(), this.permissionRepository, SocialSecurityUtils.getContext());
    }

    public void setPermissionRepository(PermissionRepository permissionRepository) {
        this.permissionRepository = permissionRepository;
    }

    public void setUgcService(UGCService ugcService) {
        this.ugcService = ugcService;
    }
}

