/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.social.security;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.craftercms.commons.http.RequestContext;
import org.craftercms.profile.api.Profile;
import org.craftercms.security.authentication.Authentication;
import org.craftercms.security.utils.SecurityUtils;
import org.craftercms.social.exceptions.ProfileConfigurationException;
import org.craftercms.social.util.ProfileUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class SocialSecurityUtils {
    public static final String CONTEXT_PARAM = "context";
    public static final String SOCIAL_CONTEXTS_ATTRIBUTE = "socialContexts";
    public static final String ANONYMOUS = "ANONYMOUS";
    public static final String SOCIAL_CONTEXT_NAME = "name";
    public static final String SOCIAL_CONTEXT_ID = "id";
    public static final String SOCIAL_CONTEXT_ROLES = "roles";

    private SocialSecurityUtils() {
    }

    public static List<String> getSocialRoles() {
        Profile profile = SocialSecurityUtils.getCurrentProfile();
        return SocialSecurityUtils.getSocialRoles((Profile)profile);
    }

    public static List<String> getSocialRoles(Profile profile) {
        return SocialSecurityUtils.getSocialRoles((Profile)profile, (String)SocialSecurityUtils.getContext());
    }

    public static List<String> getSocialRoles(Profile profile, String socialContext) {
        if (profile.getUsername().equals("ANONYMOUS")) {
            return Arrays.asList("ANONYMOUS");
        }
        List<String> list = new ArrayList(SocialSecurityUtils.getRolesForCurrentContext((String)socialContext, (Profile)profile));
        if (list == null) {
            list = Collections.synchronizedList(new ArrayList());
        }
        for (String role : profile.getRoles()) {
            if (list.contains(role)) continue;
            list.add(role);
        }
        return Collections.unmodifiableList(list);
    }

    public static String getContext() {
        HttpServletRequest request = RequestContext.getCurrent().getRequest();
        String context = request.getParameter("context");
        if (StringUtils.isBlank((CharSequence)context)) {
            throw new IllegalArgumentException("Parameter 'context' is missing from the request");
        }
        return context;
    }

    public static boolean isProfileModeratorOrAdmin(Profile updateProfile, String socialContext) {
        List roles = SocialSecurityUtils.getSocialRoles((Profile)updateProfile, (String)socialContext);
        return roles.contains("SOCIAL_ADMIN") || roles.contains("SOCIAL_SUPERADMIN") || roles.contains("SOCIAL_MODERATOR");
    }

    public static List<String> getRolesForCurrentContext(String contextId, Profile profile) {
        List socialContexts = (List)profile.getAttribute("socialContexts");
        ArrayList<String> toReturn = new ArrayList<String>();
        if (CollectionUtils.isNotEmpty((Collection)socialContexts)) {
            for (Map context : socialContexts) {
                String id = (String)context.get("id");
                if (StringUtils.isBlank((CharSequence)id)) {
                    throw new ProfileConfigurationException("Social context missing 'id'");
                }
                if (!id.equals(contextId)) continue;
                toReturn.addAll((List)context.get("roles"));
            }
            if (profile.hasAnyRole(new String[]{"SOCIAL_SUPERADMIN"})) {
                return toReturn;
            }
            return toReturn;
        }
        if (profile.hasRole("ANONYMOUS")) {
            return toReturn;
        }
        if (profile.hasRole("SOCIAL_SUPERADMIN")) {
            return toReturn;
        }
        throw new ProfileConfigurationException("Profile missing attribute 'socialContexts'");
    }

    public static Profile getCurrentProfile() {
        Authentication currentAuth = SecurityUtils.getCurrentAuthentication();
        if (currentAuth == null) {
            return ProfileUtils.getAnonymousProfile();
        }
        return currentAuth.getProfile();
    }
}

