/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.social.services.notification.impl;

import java.util.Date;
import java.util.List;
import org.craftercms.commons.audit.AuditService;
import org.craftercms.commons.i10n.I10nLogger;
import org.craftercms.commons.mongo.MongoDataException;
import org.craftercms.social.domain.audit.AuditLog;
import org.craftercms.social.exceptions.SocialException;
import org.craftercms.social.repositories.system.AuditRepository;
import org.craftercms.social.util.LoggerFactory;

public class AuditServiceImpl
extends AuditService<AuditLog> {
    private AuditRepository auditRepository;
    private I10nLogger log = LoggerFactory.getLogger(AuditServiceImpl.class);

    public AuditLog getAuditLog(String id) {
        return null;
    }

    protected void persistAudit(AuditLog auditModel) {
        try {
            this.auditRepository.save((Object)auditModel);
        }
        catch (MongoDataException e) {
            this.log.error("logging.system.auditErrorSaving", (Throwable)e, new Object[]{auditModel});
        }
    }

    protected void deleteAudits(List<String> auditId) {
        try {
            this.auditRepository.deleteByIds(auditId);
        }
        catch (SocialException e) {
            this.log.error("logging.system.unableToDeleteAudit", (Throwable)e, new Object[]{auditId});
        }
    }

    public List<AuditLog> getAuditLogs(Date from) {
        return this.getAuditLogs(from, new Date());
    }

    public List<AuditLog> getAuditLogs(Date from, Date to) {
        try {
            return this.auditRepository.getByDate(from, to);
        }
        catch (SocialException ex) {
            this.log.error("logging.system.unableToFindAudits", (Throwable)ex, new Object[]{from, to});
            return null;
        }
    }

    public void setAuditRepository(AuditRepository auditRepository) {
        this.auditRepository = auditRepository;
    }
}

