/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.social.services.notification.impl;

import freemarker.cache.TemplateLoader;
import freemarker.core.Environment;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.craftercms.commons.i10n.I10nLogger;
import org.craftercms.profile.api.Profile;
import org.craftercms.social.exceptions.SocialException;
import org.craftercms.social.services.notification.NotificationDigestService;
import org.craftercms.social.services.notification.impl.NotificationServiceImpl;
import org.craftercms.social.services.system.ContextPreferencesService;
import org.craftercms.social.services.system.EmailService;
import org.craftercms.social.util.LoggerFactory;
import org.craftercms.social.util.profile.ProfileAggregator;
import org.slf4j.Logger;

public class NotificationDigestServiceImpl
implements NotificationDigestService {
    public static final String DEFAULT_LOADPATH = "classpath:/crafter/social/notifications";
    private I10nLogger logger = LoggerFactory.getLogger(NotificationServiceImpl.class);
    private Logger log = org.slf4j.LoggerFactory.getLogger(NotificationDigestServiceImpl.class);
    private ProfileAggregator profileAggregator;
    private TemplateLoader socialFreemarkerLoader;
    private Configuration cfg;
    private EmailService emailService;
    private String systemDefaultLocale;
    private Map<String, Object> modelExt;
    private ContextPreferencesService preferencesService;

    public void setProfileAggregatorImpl(ProfileAggregator profileAggregator) {
        this.profileAggregator = profileAggregator;
    }

    public void digest(List<HashMap> auditDigest, String profileId, String type) {
        Profile toSend = this.profileAggregator.getProfile(profileId);
        if (toSend != null) {
            this.init();
            HashMap<String, Object> dataModel = new HashMap<String, Object>(this.modelExt);
            ArrayList<String> contexts = new ArrayList<String>();
            dataModel.put("profile", toSend);
            for (HashMap hashMap : auditDigest) {
                if (contexts.contains(hashMap.get("contextId"))) continue;
                contexts.add(hashMap.get("contextId").toString());
            }
            for (String contextId : contexts) {
                try {
                    StringWriter writer = new StringWriter();
                    dataModel.put("digest", auditDigest);
                    Map preferences = this.preferencesService.getContextPreferences(contextId);
                    String timezoneId = ((HashMap)preferences.get("preferences")).get("timezone").toString();
                    this.cfg.setTimeZone(TimeZone.getTimeZone(timezoneId));
                    Template template = this.cfg.getTemplate(contextId + "/" + type, this.getProfileLocale(toSend.getAttribute("notificationLocale")));
                    dataModel.put("baseUrl", preferences.get("baseUrl"));
                    Environment env = template.createProcessingEnvironment(dataModel, (Writer)writer);
                    env.process();
                    writer.flush();
                    this.emailService.sendEmail(toSend, writer, null, contextId);
                    this.log.info("Notification Email send to {} for ctxId {}", (Object)toSend.getEmail(), (Object)contextId);
                }
                catch (TemplateException | IOException | SocialException ex) {
                    this.logger.error("logging.system.notification.errorLoadingTemplate", ex, new Object[0]);
                }
            }
        } else {
            this.logger.error("Unable to send notification to profile {} it does not exist", new Object[]{profileId});
        }
    }

    private Locale getProfileLocale(Object notificationLocale) {
        if (notificationLocale == null) {
            return new Locale(this.systemDefaultLocale);
        }
        return new Locale(notificationLocale.toString());
    }

    public void init() {
        this.cfg = new Configuration(Configuration.VERSION_2_3_21);
        this.cfg.setDefaultEncoding("UTF-8");
        this.cfg.setOutputEncoding("UTF-8");
        this.cfg.setTemplateLoader(this.socialFreemarkerLoader);
    }

    public void setSocialFreemarkerLoader(TemplateLoader socialFreemarkerLoader) {
        this.socialFreemarkerLoader = socialFreemarkerLoader;
    }

    public void setEmailService(EmailService emailService) {
        this.emailService = emailService;
    }

    public void setSystemDefaultLocale(String systemDefaultLocale) {
        this.systemDefaultLocale = systemDefaultLocale;
    }

    public void setPreferencesService(ContextPreferencesService preferencesService) {
        this.preferencesService = preferencesService;
    }

    public void setModelExt(Map modelExt) {
        this.modelExt = modelExt;
    }
}

