/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.social.services.notification.impl;

import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.craftercms.commons.i10n.I10nLogger;
import org.craftercms.commons.mongo.MongoDataException;
import org.craftercms.commons.security.permissions.annotations.HasPermission;
import org.craftercms.profile.api.Profile;
import org.craftercms.security.exception.AuthenticationRequiredException;
import org.craftercms.social.domain.notifications.ThreadsToNotify;
import org.craftercms.social.domain.notifications.WatchedThread;
import org.craftercms.social.exceptions.NotificationException;
import org.craftercms.social.exceptions.SocialException;
import org.craftercms.social.repositories.system.AuditRepository;
import org.craftercms.social.repositories.system.impl.AuditRepositoryImpl;
import org.craftercms.social.repositories.system.notifications.WatchedThreadsRepository;
import org.craftercms.social.repositories.system.notifications.impl.WatchedThreadsRepositoryImpl;
import org.craftercms.social.security.SocialPermission;
import org.craftercms.social.security.SocialSecurityUtils;
import org.craftercms.social.services.notification.NotificationDigestService;
import org.craftercms.social.services.notification.NotificationService;
import org.craftercms.social.services.notification.impl.NotificationDigestServiceImpl;
import org.craftercms.social.util.LoggerFactory;
import org.craftercms.social.util.profile.ProfileAggregator;
import org.quartz.SimpleTrigger;
import org.slf4j.Logger;

public class NotificationServiceImpl
implements NotificationService {
    private AuditRepository auditRepository;
    private WatchedThreadsRepository watchedThreadsRepository;
    private I10nLogger log = LoggerFactory.getLogger(NotificationServiceImpl.class);
    private SimpleTrigger instantTrigger;
    private ProfileAggregator profileAggregator;
    private NotificationDigestService notificationDigestService;
    private Date lastInstantFire;
    private Logger logger = org.slf4j.LoggerFactory.getLogger(NotificationDigestServiceImpl.class);
    private boolean disableNotifications;

    public NotificationServiceImpl() {
        this.lastInstantFire = new Date();
    }

    @HasPermission(action="ugc.read", type=SocialPermission.class)
    public void subscribeUser(Profile profile, String threadId, String frequency) throws NotificationException {
        String frequencyToUse = frequency;
        try {
            WatchedThread thread = (WatchedThread)this.watchedThreadsRepository.findByStringId(threadId);
            if (thread == null) {
                this.log.debug("logging.system.notification.creatingSubscription", new Object[]{threadId});
                thread = new WatchedThread();
                thread.setThreadId(threadId);
                this.watchedThreadsRepository.save((Object)thread);
            }
            this.log.debug("logging.system.notification.adding", new Object[]{profile, threadId, frequency});
            if (StringUtils.isBlank((CharSequence)frequency)) {
                if (profile.getAttributes().containsKey("defaultFrequency")) {
                    frequencyToUse = (String)profile.getAttribute("defaultFrequency");
                    if (StringUtils.isBlank((CharSequence)frequencyToUse)) {
                        throw new IllegalArgumentException("Profile defaultFrequency can't be empty");
                    }
                } else {
                    throw new IllegalArgumentException("Profile defaultFrequency must be set or send a valid frequency");
                }
            }
            this.watchedThreadsRepository.addWatcher(thread.getThreadId(), profile.getId().toString(), frequencyToUse);
        }
        catch (MongoDataException e) {
            throw new NotificationException("Unable to subscribe User", (Throwable)e);
        }
    }

    @HasPermission(action="ugc.read", type=SocialPermission.class)
    public void unSubscribeUser(String userId, String threadId) throws NotificationException {
        try {
            WatchedThread thread = (WatchedThread)this.watchedThreadsRepository.findByStringId(threadId);
            if (thread != null) {
                this.watchedThreadsRepository.removeWatcher(thread.getThreadId(), userId);
            }
            this.log.debug("logging.system.notification.remove", new Object[]{userId, threadId});
        }
        catch (MongoDataException e) {
            throw new NotificationException("Unable to subscribe User", (Throwable)e);
        }
    }

    public boolean isBeenWatch(String threadId, String profileId) throws NotificationException {
        try {
            WatchedThread thread = this.watchedThreadsRepository.isUserSubscribe(threadId, profileId);
            return thread != null;
        }
        catch (MongoDataException e) {
            throw new NotificationException("Unable to Check if user is subscribed", (Throwable)e);
        }
    }

    public void notify(String type) {
        if (!this.disableNotifications) {
            Date from = this.getStartDateByType(type);
            this.lastInstantFire = new Date();
            Date to = new Date();
            try {
                List toBeSend = this.watchedThreadsRepository.findProfilesToSend(type);
                for (ThreadsToNotify threadsToNotify : toBeSend) {
                    this.logger.info("Notifying {} users for {} from {} until {} ", new Object[]{threadsToNotify.getProfiles().size(), type, from, to});
                    for (String profileId : threadsToNotify.getProfiles()) {
                        List auditDigest = this.auditRepository.getNotificationDigest(threadsToNotify.getThreadId(), from, to, Arrays.asList(profileId));
                        this.logger.info("Notifying {} sending {} ugs {}", new Object[]{profileId, threadsToNotify.getThreadId(), auditDigest.size()});
                        this.notificationDigestService.digest(auditDigest, profileId, type);
                    }
                }
            }
            catch (SocialException ex) {
                this.logger.error("Unable to send notifications", (Throwable)ex);
            }
        }
    }

    public List<Map> getUserSubscriptions() throws SocialException {
        Profile p = SocialSecurityUtils.getCurrentProfile();
        if (p != null && !p.getUsername().equalsIgnoreCase("ANONYMOUS")) {
            return this.watchedThreadsRepository.findUserWatchedThreads(p.getId().toString());
        }
        throw new AuthenticationRequiredException("User is not authenticated");
    }

    public void changeSubscription(Profile p, String threadId, String frequency) throws NotificationException {
        if (this.isBeenWatch(threadId, p.getId().toString())) {
            String frequencyToUse = frequency;
            if (StringUtils.isBlank((CharSequence)frequencyToUse)) {
                if (p.getAttributes().containsKey("defaultFrequency")) {
                    frequencyToUse = (String)p.getAttribute("defaultFrequency");
                    if (StringUtils.isBlank((CharSequence)frequencyToUse)) {
                        throw new IllegalArgumentException("Profile defaultFrequency can't be empty");
                    }
                } else {
                    throw new IllegalArgumentException("Profile defaultFrequency must be set or send a valid frequency");
                }
            }
            this.watchedThreadsRepository.removeWatcher(threadId, p.getId().toString());
            this.watchedThreadsRepository.addWatcher(threadId, p.getId().toString(), frequencyToUse);
        }
    }

    protected Date getStartDateByType(String type) {
        Calendar cal = Calendar.getInstance();
        if (type.equalsIgnoreCase("weekly")) {
            cal.add(3, -1);
            return cal.getTime();
        }
        if (type.equalsIgnoreCase("daily")) {
            cal.add(5, -1);
            return cal.getTime();
        }
        if (type.equalsIgnoreCase("instant")) {
            return this.lastInstantFire;
        }
        return null;
    }

    public void setInstantTrigger(SimpleTrigger instantTrigger) {
        this.instantTrigger = instantTrigger;
    }

    public void setAuditRepository(AuditRepositoryImpl auditRepository) {
        this.auditRepository = auditRepository;
    }

    public void setWatchedThreadsRepository(WatchedThreadsRepositoryImpl watchedThreadsRepository) {
        this.watchedThreadsRepository = watchedThreadsRepository;
    }

    public void setProfileAggregatorImpl(ProfileAggregator profileAggregator) {
        this.profileAggregator = profileAggregator;
    }

    public void setNotificationDigestServiceImpl(NotificationDigestService notificationDigestService) {
        this.notificationDigestService = notificationDigestService;
    }

    public void setDisableNotifications(boolean disableNotifications) {
        this.disableNotifications = disableNotifications;
    }
}

